/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spockframework.runtime.extension.ExtensionAnnotation;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRunner {
    private final SpecInfo spec;
    private final List<IGlobalExtension> globalExtensions;
    private final Map<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension> localExtensions = new HashMap<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension>();

    public ExtensionRunner(SpecInfo specInfo, List<IGlobalExtension> list) {
        this.spec = specInfo;
        this.globalExtensions = list;
    }

    public void run() {
        this.runGlobalExtensions();
        this.runAnnotationDrivenExtensions();
    }

    private void runGlobalExtensions() {
        for (IGlobalExtension iGlobalExtension : this.globalExtensions) {
            iGlobalExtension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions() {
        this.runAnnotationDrivenExtensions(this.spec);
        for (IAnnotationDrivenExtension iAnnotationDrivenExtension : this.localExtensions.values()) {
            iAnnotationDrivenExtension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions(SpecInfo specInfo) {
        if (specInfo == null) {
            return;
        }
        this.runAnnotationDrivenExtensions(specInfo.getSuperSpec());
        this.doRunAnnotationDrivenExtensions(specInfo);
        for (FieldInfo nodeInfo : specInfo.getFields()) {
            this.doRunAnnotationDrivenExtensions(nodeInfo);
        }
        this.doRunAnnotationDrivenExtensions(specInfo.getSetupSpecMethod());
        this.doRunAnnotationDrivenExtensions(specInfo.getSetupMethod());
        this.doRunAnnotationDrivenExtensions(specInfo.getCleanupMethod());
        this.doRunAnnotationDrivenExtensions(specInfo.getCleanupSpecMethod());
        for (FeatureInfo featureInfo : specInfo.getFeatures()) {
            this.doRunAnnotationDrivenExtensions(featureInfo.getFeatureMethod());
        }
    }

    private void doRunAnnotationDrivenExtensions(NodeInfo<?, ?> nodeInfo) {
        if (nodeInfo.isStub()) {
            return;
        }
        for (Annotation annotation : nodeInfo.getReflection().getAnnotations()) {
            ExtensionAnnotation extensionAnnotation = annotation.annotationType().getAnnotation(ExtensionAnnotation.class);
            if (extensionAnnotation == null) continue;
            IAnnotationDrivenExtension iAnnotationDrivenExtension = this.getOrCreateExtension(extensionAnnotation.value());
            if (nodeInfo instanceof SpecInfo) {
                iAnnotationDrivenExtension.visitSpecAnnotation(annotation, (SpecInfo)nodeInfo);
                continue;
            }
            if (nodeInfo instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)nodeInfo;
                if (methodInfo.getKind() == MethodKind.FEATURE) {
                    iAnnotationDrivenExtension.visitFeatureAnnotation(annotation, methodInfo.getFeature());
                    continue;
                }
                iAnnotationDrivenExtension.visitFixtureAnnotation(annotation, methodInfo);
                continue;
            }
            iAnnotationDrivenExtension.visitFieldAnnotation(annotation, (FieldInfo)nodeInfo);
        }
    }

    private IAnnotationDrivenExtension getOrCreateExtension(Class<? extends IAnnotationDrivenExtension> clazz) {
        IAnnotationDrivenExtension iAnnotationDrivenExtension = this.localExtensions.get(clazz);
        if (iAnnotationDrivenExtension == null) {
            try {
                iAnnotationDrivenExtension = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ExtensionException("Failed to instantiate extension '%s'", instantiationException).withArgs(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExtensionException("No-arg constructor of extension '%s' is not public", illegalAccessException).withArgs(clazz);
            }
            this.localExtensions.put(clazz, iAnnotationDrivenExtension);
        }
        return iAnnotationDrivenExtension;
    }
}

