/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.runner.Description;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class JUnitDescriptionGenerator {
    private final SpecInfo spec;

    public JUnitDescriptionGenerator(SpecInfo specInfo) {
        this.spec = specInfo;
    }

    public void attach() {
        Description description = Description.createSuiteDescription((Class)((Class)this.spec.getReflection()));
        this.spec.setDescription(description);
        for (FeatureInfo nodeInfo : this.spec.getAllFeatures()) {
            this.describeFeature(nodeInfo);
        }
        for (MethodInfo methodInfo : this.spec.getAllFixtureMethods()) {
            this.describeMethod(methodInfo);
        }
    }

    public Description aggregate() {
        Description description = this.spec.getDescription();
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            return description;
        }
        for (FeatureInfo featureInfo : this.spec.getAllFeaturesInExecutionOrder()) {
            if (featureInfo.isExcluded() || featureInfo.isReportIterations()) continue;
            description.addChild(featureInfo.getFeatureMethod().getDescription());
        }
        return description;
    }

    private Description describeFeature(FeatureInfo featureInfo) {
        Description description = this.describeMethod(featureInfo.getFeatureMethod());
        featureInfo.setDescription(description);
        if (featureInfo.getDataProcessorMethod() != null) {
            featureInfo.getDataProcessorMethod().setDescription(description);
        }
        for (DataProviderInfo dataProviderInfo : featureInfo.getDataProviders()) {
            dataProviderInfo.getDataProviderMethod().setDescription(description);
        }
        return description;
    }

    private Description describeMethod(MethodInfo methodInfo) {
        Annotation[] annotationArray = methodInfo.getReflection() == null ? new Annotation[]{} : ((Method)methodInfo.getReflection()).getAnnotations();
        Description description = Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)methodInfo.getName(), (Annotation[])annotationArray);
        methodInfo.setDescription(description);
        return description;
    }
}

