/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.MasterRunListener;
import org.spockframework.runtime.SpockComparisonFailure;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitSupervisor
implements IRunSupervisor {
    private final SpecInfo spec;
    private final RunNotifier notifier;
    private final IStackTraceFilter filter;
    private final IRunListener masterListener;
    private final IObjectRenderer<Object> diffedObjectRenderer;
    private FeatureInfo currentFeature;
    private IterationInfo currentIteration;
    private int iterationCount;
    private boolean errorSinceLastReset;

    public JUnitSupervisor(SpecInfo specInfo, RunNotifier runNotifier, IStackTraceFilter iStackTraceFilter, IObjectRenderer<Object> iObjectRenderer) {
        this.spec = specInfo;
        this.notifier = runNotifier;
        this.filter = iStackTraceFilter;
        this.masterListener = new MasterRunListener(specInfo);
        this.diffedObjectRenderer = iObjectRenderer;
    }

    @Override
    public void beforeSpec(SpecInfo specInfo) {
        this.masterListener.beforeSpec(specInfo);
    }

    @Override
    public void beforeFeature(FeatureInfo featureInfo) {
        this.masterListener.beforeFeature(featureInfo);
        this.currentFeature = featureInfo;
        if (!featureInfo.isReportIterations()) {
            this.notifier.fireTestStarted(featureInfo.getDescription());
        }
        if (featureInfo.isParameterized()) {
            this.iterationCount = 0;
            this.errorSinceLastReset = false;
        }
    }

    @Override
    public void beforeIteration(IterationInfo iterationInfo) {
        this.masterListener.beforeIteration(iterationInfo);
        this.currentIteration = iterationInfo;
        ++this.iterationCount;
        if (this.currentFeature.isReportIterations()) {
            this.notifier.fireTestStarted(iterationInfo.getDescription());
        }
    }

    @Override
    public int error(ErrorInfo errorInfo) {
        Throwable throwable = errorInfo.getException();
        if (throwable instanceof MultipleFailureException) {
            return this.handleMultipleFailures(errorInfo);
        }
        if (this.isFailedEqualityComparison(throwable)) {
            throwable = this.convertToComparisonFailure(throwable);
        }
        this.filter.filter(throwable);
        Failure failure = new Failure(this.getCurrentDescription(), throwable);
        if (throwable instanceof AssumptionViolatedException) {
            if (this.currentIteration == null || !this.currentFeature.isParameterized() || this.currentFeature.isReportIterations()) {
                this.notifier.fireTestAssumptionFailed(failure);
            }
        } else {
            this.masterListener.error(errorInfo);
            this.notifier.fireTestFailure(failure);
        }
        this.errorSinceLastReset = true;
        return this.statusFor(errorInfo);
    }

    private int handleMultipleFailures(ErrorInfo errorInfo) {
        MultipleFailureException multipleFailureException = (MultipleFailureException)errorInfo.getException();
        int n = 0;
        for (Throwable throwable : multipleFailureException.getFailures()) {
            n = this.error(new ErrorInfo(errorInfo.getMethod(), throwable));
        }
        return n;
    }

    private boolean isFailedEqualityComparison(Throwable throwable) {
        if (!(throwable instanceof ConditionNotSatisfiedError)) {
            return false;
        }
        Condition condition = ((ConditionNotSatisfiedError)((Object)throwable)).getCondition();
        ExpressionInfo expressionInfo = condition.getExpression();
        return expressionInfo != null && expressionInfo.isEqualityComparison();
    }

    private Throwable convertToComparisonFailure(Throwable throwable) {
        assert (this.isFailedEqualityComparison(throwable));
        Condition condition = ((ConditionNotSatisfiedError)((Object)throwable)).getCondition();
        ExpressionInfo expressionInfo = condition.getExpression();
        String string = this.renderValue(expressionInfo.getChildren().get(0).getValue());
        String string2 = this.renderValue(expressionInfo.getChildren().get(1).getValue());
        SpockComparisonFailure spockComparisonFailure = new SpockComparisonFailure(condition, string2, string);
        spockComparisonFailure.setStackTrace(throwable.getStackTrace());
        return spockComparisonFailure;
    }

    private String renderValue(Object object) {
        try {
            return this.diffedObjectRenderer.render(object);
        }
        catch (Throwable throwable) {
            return "Failed to render value due to:\n\n" + TextUtil.printStackTrace(throwable);
        }
    }

    private int statusFor(ErrorInfo errorInfo) {
        switch (errorInfo.getMethod().getKind()) {
            case DATA_PROCESSOR: 
            case INITIALIZER: 
            case ITERATION_EXECUTION: 
            case SETUP: 
            case CLEANUP: 
            case FEATURE: {
                return 5;
            }
            case FEATURE_EXECUTION: 
            case DATA_PROVIDER: {
                return 9;
            }
            case SHARED_INITIALIZER: 
            case SETUP_SPEC: 
            case CLEANUP_SPEC: 
            case SPEC_EXECUTION: {
                return 17;
            }
        }
        throw new InternalSpockError("unknown method kind");
    }

    @Override
    public void afterIteration(IterationInfo iterationInfo) {
        this.masterListener.afterIteration(iterationInfo);
        if (this.currentFeature.isReportIterations()) {
            this.notifier.fireTestFinished(iterationInfo.getDescription());
        }
        this.currentIteration = null;
    }

    @Override
    public void afterFeature(FeatureInfo featureInfo) {
        if (featureInfo.isParameterized() && this.iterationCount == 0 && !this.errorSinceLastReset) {
            this.notifier.fireTestFailure(new Failure(featureInfo.getDescription(), (Throwable)new SpockExecutionException("Data provider has no data")));
        }
        this.masterListener.afterFeature(featureInfo);
        if (!featureInfo.isReportIterations()) {
            this.notifier.fireTestFinished(featureInfo.getDescription());
        }
        this.currentFeature = null;
    }

    @Override
    public void afterSpec(SpecInfo specInfo) {
        this.masterListener.afterSpec(specInfo);
    }

    @Override
    public void specSkipped(SpecInfo specInfo) {
        this.masterListener.specSkipped(specInfo);
        this.notifier.fireTestIgnored(specInfo.getDescription());
    }

    @Override
    public void featureSkipped(FeatureInfo featureInfo) {
        this.masterListener.featureSkipped(featureInfo);
        this.notifier.fireTestIgnored(featureInfo.getDescription());
    }

    private Description getCurrentDescription() {
        if (this.currentIteration != null && this.currentFeature.isReportIterations()) {
            return this.currentIteration.getDescription();
        }
        if (this.currentFeature != null) {
            return this.currentFeature.getDescription();
        }
        return this.spec.getDescription();
    }
}

