/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

public class MasterRunListener
implements IRunListener {
    private final SpecInfo spec;

    public MasterRunListener(SpecInfo specInfo) {
        this.spec = specInfo;
    }

    public void beforeSpec(SpecInfo specInfo) {
        for (IRunListener iRunListener : specInfo.getListeners()) {
            iRunListener.beforeSpec(specInfo);
        }
    }

    public void beforeFeature(FeatureInfo featureInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.beforeFeature(featureInfo);
        }
    }

    public void beforeIteration(IterationInfo iterationInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.beforeIteration(iterationInfo);
        }
    }

    public void afterIteration(IterationInfo iterationInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.afterIteration(iterationInfo);
        }
    }

    public void afterFeature(FeatureInfo featureInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.afterFeature(featureInfo);
        }
    }

    public void afterSpec(SpecInfo specInfo) {
        for (IRunListener iRunListener : specInfo.getListeners()) {
            iRunListener.afterSpec(specInfo);
        }
    }

    public void error(ErrorInfo errorInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.error(errorInfo);
        }
    }

    public void specSkipped(SpecInfo specInfo) {
        for (IRunListener iRunListener : specInfo.getListeners()) {
            iRunListener.specSkipped(specInfo);
        }
    }

    public void featureSkipped(FeatureInfo featureInfo) {
        for (IRunListener iRunListener : this.spec.getListeners()) {
            iRunListener.featureSkipped(featureInfo);
        }
    }
}

