/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.spockframework.runtime.SpecUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=OptimizeRunOrderSuite.class)
public class OptimizeRunOrderSuite
extends Suite {
    public static final String CLASSES_TO_RUN_KEY = OptimizeRunOrderSuite.class.getName() + ".classesToRun";

    public OptimizeRunOrderSuite(Class<?> clazz, RunnerBuilder runnerBuilder) throws InitializationError {
        super(runnerBuilder, clazz, (Class[])OptimizeRunOrderSuite.loadAndReorderClassesToRun());
    }

    private static Class<?>[] loadAndReorderClassesToRun() throws InitializationError {
        List<String> list = OptimizeRunOrderSuite.getClassesToRun();
        SpecUtil.optimizeRunOrder(list);
        List<Class<?>> list2 = OptimizeRunOrderSuite.loadClasses(list);
        return list2.toArray(new Class[list2.size()]);
    }

    private static List<String> getClassesToRun() throws InitializationError {
        String string = System.getProperty(CLASSES_TO_RUN_KEY);
        if (string == null) {
            throw new InitializationError(String.format("system property '%s' is not set", CLASSES_TO_RUN_KEY));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private static List<Class<?>> loadClasses(List<String> list) throws InitializationError {
        ArrayList arrayList = new ArrayList();
        ClassLoader classLoader = OptimizeRunOrderSuite.class.getClassLoader();
        try {
            for (String string : list) {
                arrayList.add(classLoader.loadClass(string));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InitializationError((Throwable)classNotFoundException);
        }
        return arrayList;
    }
}

