/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Iterator;
import java.util.List;
import org.spockframework.runtime.BaseSpecRunner;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.RunStatus;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.GroovyRuntimeUtil;

public class ParameterizedSpecRunner
extends BaseSpecRunner {
    public ParameterizedSpecRunner(SpecInfo specInfo, IRunSupervisor iRunSupervisor) {
        super(specInfo, iRunSupervisor);
    }

    protected void runParameterizedFeature() {
        if (this.runStatus != 0) {
            return;
        }
        Object[] objectArray = this.createDataProviders();
        int n = this.estimateNumIterations(objectArray);
        Iterator[] iteratorArray = this.createIterators(objectArray);
        this.runIterations(iteratorArray, n);
        this.closeDataProviders(objectArray);
    }

    private Object[] createDataProviders() {
        if (this.runStatus != 0) {
            return null;
        }
        List<DataProviderInfo> list = this.currentFeature.getDataProviders();
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MethodInfo methodInfo = list.get(i).getDataProviderMethod();
            Object object = this.invokeRaw(this.sharedInstance, methodInfo, EMPTY_ARGS);
            if (this.runStatus != 0) {
                return null;
            }
            if (object == null) {
                this.runStatus = this.supervisor.error(new ErrorInfo(methodInfo, new SpockExecutionException("Data provider is null")));
                return null;
            }
            objectArray[i] = object;
        }
        return objectArray;
    }

    private Iterator[] createIterators(Object[] objectArray) {
        if (this.runStatus != 0) {
            return null;
        }
        Iterator[] iteratorArray = new Iterator[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Iterator<Object> iterator = GroovyRuntimeUtil.asIterator(objectArray[i]);
                if (iterator == null) {
                    this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), new SpockExecutionException("Data provider's iterator() method returned null")));
                    return null;
                }
                iteratorArray[i] = iterator;
                continue;
            }
            catch (Throwable throwable) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), throwable));
                return null;
            }
        }
        return iteratorArray;
    }

    private int estimateNumIterations(Object[] objectArray) {
        if (this.runStatus != 0) {
            return -1;
        }
        if (objectArray.length == 0) {
            return 1;
        }
        int n = Integer.MAX_VALUE;
        for (Object object : objectArray) {
            int n2;
            Object object2;
            if (object instanceof Iterator || !((object2 = GroovyRuntimeUtil.invokeMethodQuietly(object, "size", new Object[0])) instanceof Number) || (n2 = ((Number)object2).intValue()) < 0 || n2 >= n) continue;
            n = n2;
        }
        return n == Integer.MAX_VALUE ? -1 : n;
    }

    private void runIterations(Iterator[] iteratorArray, int n) {
        if (this.runStatus != 0) {
            return;
        }
        while (this.haveNext(iteratorArray)) {
            this.initializeAndRunIteration(this.nextArgs(iteratorArray), n);
            if (this.resetStatus(4) == 0 && iteratorArray.length != 0) continue;
            break;
        }
    }

    private void closeDataProviders(Object[] objectArray) {
        if (RunStatus.action(this.runStatus) == 2) {
            return;
        }
        if (objectArray == null) {
            return;
        }
        for (Object object : objectArray) {
            GroovyRuntimeUtil.invokeMethodQuietly(object, "close", new Object[0]);
        }
    }

    private boolean haveNext(Iterator[] iteratorArray) {
        if (this.runStatus != 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < iteratorArray.length; ++i) {
            try {
                boolean bl2 = iteratorArray[i].hasNext();
                if (i == 0) {
                    bl = bl2;
                    continue;
                }
                if (bl == bl2) continue;
                DataProviderInfo dataProviderInfo = this.currentFeature.getDataProviders().get(i);
                this.runStatus = this.supervisor.error(new ErrorInfo(dataProviderInfo.getDataProviderMethod(), this.createDifferentNumberOfDataValuesException(dataProviderInfo, bl2)));
                return false;
            }
            catch (Throwable throwable) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), throwable));
                return false;
            }
        }
        return bl;
    }

    private SpockExecutionException createDifferentNumberOfDataValuesException(DataProviderInfo dataProviderInfo, boolean bl) {
        String string = String.format("Data provider for variable '%s' has %s values than previous data provider(s)", dataProviderInfo.getDataVariables().get(0), bl ? "more" : "fewer");
        SpockExecutionException spockExecutionException = new SpockExecutionException(string);
        FeatureInfo featureInfo = (FeatureInfo)dataProviderInfo.getParent();
        SpecInfo specInfo = (SpecInfo)featureInfo.getParent();
        StackTraceElement stackTraceElement = new StackTraceElement(((Class)specInfo.getReflection()).getName(), featureInfo.getName(), specInfo.getFilename(), dataProviderInfo.getLine());
        spockExecutionException.setStackTrace(new StackTraceElement[]{stackTraceElement});
        return spockExecutionException;
    }

    private Object[] nextArgs(Iterator[] iteratorArray) {
        if (this.runStatus != 0) {
            return null;
        }
        Object[] objectArray = new Object[iteratorArray.length];
        for (int i = 0; i < iteratorArray.length; ++i) {
            try {
                objectArray[i] = iteratorArray[i].next();
                continue;
            }
            catch (Throwable throwable) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), throwable));
                return null;
            }
        }
        try {
            return (Object[])this.invokeRaw(this.sharedInstance, this.currentFeature.getDataProcessorMethod(), objectArray);
        }
        catch (Throwable throwable) {
            this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProcessorMethod(), throwable));
            return null;
        }
    }
}

