/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.junit.runner.notification.RunNotifier;
import org.spockframework.builder.DelegatingScript;
import org.spockframework.runtime.ConfigurationBuilder;
import org.spockframework.runtime.ConfigurationScriptLoader;
import org.spockframework.runtime.DummyStackTraceFilter;
import org.spockframework.runtime.ExtensionClassesLoader;
import org.spockframework.runtime.ExtensionRegistry;
import org.spockframework.runtime.ExtensionRunner;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.JUnitSupervisor;
import org.spockframework.runtime.ParameterizedSpecRunner;
import org.spockframework.runtime.StackTraceFilter;
import org.spockframework.runtime.condition.DiffedArrayRenderer;
import org.spockframework.runtime.condition.DiffedCollectionRenderer;
import org.spockframework.runtime.condition.DiffedMapRenderer;
import org.spockframework.runtime.condition.DiffedObjectAsBeanRenderer;
import org.spockframework.runtime.condition.DiffedObjectAsStringRenderer;
import org.spockframework.runtime.condition.DiffedSetRenderer;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.condition.ObjectRendererService;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IThrowableFunction;
import spock.config.RunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunContext {
    private static final ThreadLocal<LinkedList<RunContext>> contextStacks = new ThreadLocal<LinkedList<RunContext>>(){

        @Override
        protected LinkedList<RunContext> initialValue() {
            return new LinkedList<RunContext>();
        }
    };
    private final List<Class<?>> extensionClasses;
    private final ExtensionRegistry extensionRegistry;
    private final List<Object> configurations = new ArrayList<Object>();
    private final RunnerConfiguration runnerConfiguration = new RunnerConfiguration();
    private final IObjectRenderer<Object> diffedObjectRenderer = this.createDiffedObjectRenderer();

    private RunContext(DelegatingScript delegatingScript, List<Class<?>> list) {
        this.extensionClasses = list;
        this.configurations.add(this.runnerConfiguration);
        this.extensionRegistry = new ExtensionRegistry(list, this.configurations);
        this.extensionRegistry.loadExtensions();
        if (delegatingScript != null) {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
            configurationBuilder.build(this.configurations, delegatingScript);
        }
    }

    public ExtensionRunner createExtensionRunner(SpecInfo specInfo) {
        return new ExtensionRunner(specInfo, this.extensionRegistry.getExtensions());
    }

    public ParameterizedSpecRunner createSpecRunner(SpecInfo specInfo, RunNotifier runNotifier) {
        return new ParameterizedSpecRunner(specInfo, new JUnitSupervisor(specInfo, runNotifier, this.createStackTraceFilter(specInfo), this.diffedObjectRenderer));
    }

    public <T> T getConfiguration(Class<T> clazz) {
        for (Object object : this.configurations) {
            if (object.getClass() != clazz) continue;
            return clazz.cast(object);
        }
        return null;
    }

    private IStackTraceFilter createStackTraceFilter(SpecInfo specInfo) {
        return this.runnerConfiguration.filterStackTrace ? new StackTraceFilter(specInfo) : new DummyStackTraceFilter();
    }

    private IObjectRenderer<Object> createDiffedObjectRenderer() {
        ObjectRendererService objectRendererService = new ObjectRendererService();
        objectRendererService.addRenderer(Object.class, new DiffedObjectAsBeanRenderer());
        DiffedObjectAsStringRenderer diffedObjectAsStringRenderer = new DiffedObjectAsStringRenderer();
        objectRendererService.addRenderer(CharSequence.class, diffedObjectAsStringRenderer);
        objectRendererService.addRenderer(Number.class, diffedObjectAsStringRenderer);
        objectRendererService.addRenderer(Character.class, diffedObjectAsStringRenderer);
        objectRendererService.addRenderer(Boolean.class, diffedObjectAsStringRenderer);
        objectRendererService.addRenderer(Collection.class, new DiffedCollectionRenderer());
        objectRendererService.addRenderer(Set.class, new DiffedSetRenderer(true));
        objectRendererService.addRenderer(SortedSet.class, new DiffedSetRenderer(false));
        objectRendererService.addRenderer(Map.class, new DiffedMapRenderer(true));
        objectRendererService.addRenderer(SortedMap.class, new DiffedMapRenderer(false));
        DiffedArrayRenderer diffedArrayRenderer = new DiffedArrayRenderer();
        objectRendererService.addRenderer(Object[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(byte[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(short[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(int[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(long[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(float[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(double[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(char[].class, diffedArrayRenderer);
        objectRendererService.addRenderer(boolean[].class, diffedArrayRenderer);
        return objectRendererService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U extends Throwable> T withNewContext(DelegatingScript delegatingScript, List<Class<?>> list, boolean bl, IThrowableFunction<RunContext, T, U> iThrowableFunction) throws U {
        ArrayList arrayList = new ArrayList(list);
        if (bl) {
            arrayList.addAll(RunContext.getCurrentExtensions());
        }
        RunContext runContext = new RunContext(delegatingScript, arrayList);
        LinkedList<RunContext> linkedList = contextStacks.get();
        linkedList.addFirst(runContext);
        try {
            T t = iThrowableFunction.apply(runContext);
            return t;
        }
        finally {
            linkedList.removeFirst();
        }
    }

    public static RunContext get() {
        LinkedList<RunContext> linkedList = contextStacks.get();
        RunContext runContext = linkedList.peek();
        if (runContext == null) {
            runContext = RunContext.createBottomContext();
            linkedList.addFirst(runContext);
        }
        return runContext;
    }

    private static List<Class<?>> getCurrentExtensions() {
        RunContext runContext = contextStacks.get().peek();
        if (runContext == null) {
            return Collections.emptyList();
        }
        return runContext.extensionClasses;
    }

    private static RunContext createBottomContext() {
        DelegatingScript delegatingScript = new ConfigurationScriptLoader().loadAutoDetectedScript();
        List<Class<?>> list = new ExtensionClassesLoader().loadClassesFromDefaultLocation();
        return new RunContext(delegatingScript, list);
    }
}

