/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.SpecUtil;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.DataProviderMetadata;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.SpecMetadata;
import org.spockframework.util.InternalIdentifiers;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecInfoBuilder {
    private final Class<?> clazz;
    private final SpecInfo spec = new SpecInfo();

    public SpecInfoBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public SpecInfo build() {
        this.doBuild();
        int n = 0;
        for (SpecInfo specInfo : this.spec.getSpecsTopToBottom()) {
            for (FeatureInfo featureInfo : specInfo.getFeatures()) {
                featureInfo.setDeclarationOrder(n);
                featureInfo.setExecutionOrder(n);
                ++n;
            }
        }
        return this.spec;
    }

    private SpecInfo doBuild() {
        this.buildSuperSpec();
        this.buildSpec();
        this.buildFields();
        this.buildSharedInstanceField();
        this.buildFeatures();
        this.buildInitializerMethods();
        this.buildFixtureMethods();
        return this.spec;
    }

    private void buildSuperSpec() {
        Class<?> clazz = this.clazz.getSuperclass();
        if (clazz == Object.class || clazz == Specification.class) {
            return;
        }
        SpecInfo specInfo = new SpecInfoBuilder(clazz).doBuild();
        this.spec.setSuperSpec(specInfo);
        specInfo.setSubSpec(this.spec);
    }

    private void buildSpec() {
        SpecUtil.checkIsSpec(this.clazz);
        SpecMetadata specMetadata = this.clazz.getAnnotation(SpecMetadata.class);
        this.spec.setParent(null);
        this.spec.setName(this.clazz.getSimpleName());
        this.spec.setLine(specMetadata.line());
        this.spec.setReflection(this.clazz);
        this.spec.setFilename(specMetadata.filename());
    }

    private void buildFields() {
        for (Field field : this.clazz.getDeclaredFields()) {
            FieldMetadata fieldMetadata = field.getAnnotation(FieldMetadata.class);
            if (fieldMetadata == null) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setParent(this.spec);
            fieldInfo.setReflection(field);
            fieldInfo.setName(fieldMetadata.name());
            fieldInfo.setOrdinal(fieldMetadata.ordinal());
            fieldInfo.setLine(fieldMetadata.line());
            this.spec.addField(fieldInfo);
        }
        Collections.sort(this.spec.getFields(), new Comparator<FieldInfo>(){

            @Override
            public int compare(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
                return fieldInfo.getOrdinal() - fieldInfo2.getOrdinal();
            }
        });
    }

    private void buildSharedInstanceField() {
        Field field = this.getSharedInstanceField();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setParent(this.spec);
        fieldInfo.setName(field.getName());
        fieldInfo.setReflection(field);
        this.spec.setSharedInstanceField(fieldInfo);
    }

    private Field getSharedInstanceField() {
        try {
            return this.clazz.getField("$spock_sharedInstance");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InternalSpockError("cannot find shared instance field");
        }
    }

    private void buildFeatures() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            FeatureMetadata featureMetadata = method.getAnnotation(FeatureMetadata.class);
            if (featureMetadata == null) continue;
            method.setAccessible(true);
            this.spec.addFeature(this.createFeature(method, featureMetadata));
        }
        this.spec.sortFeatures(new IFeatureSortOrder(){

            public int compare(FeatureInfo featureInfo, FeatureInfo featureInfo2) {
                return featureInfo.getDeclarationOrder() - featureInfo2.getDeclarationOrder();
            }
        });
    }

    private FeatureInfo createFeature(Method method, FeatureMetadata featureMetadata) {
        FeatureInfo featureInfo = new FeatureInfo();
        featureInfo.setParent(this.spec);
        featureInfo.setName(featureMetadata.name());
        featureInfo.setLine(featureMetadata.line());
        featureInfo.setDeclarationOrder(featureMetadata.ordinal());
        for (String string : featureMetadata.parameterNames()) {
            featureInfo.addParameterName(string);
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.spec);
        methodInfo.setName(featureMetadata.name());
        methodInfo.setLine(featureMetadata.line());
        methodInfo.setFeature(featureInfo);
        methodInfo.setReflection(method);
        methodInfo.setKind(MethodKind.FEATURE);
        featureInfo.setFeatureMethod(methodInfo);
        String string = InternalIdentifiers.getDataProcessorName(method.getName());
        MethodInfo methodInfo2 = this.createMethod(string, MethodKind.DATA_PROCESSOR, false);
        if (methodInfo2 != null) {
            featureInfo.setDataProcessorMethod(methodInfo2);
            int n = 0;
            String string2 = InternalIdentifiers.getDataProviderName(method.getName(), n++);
            MethodInfo methodInfo3 = this.createMethod(string2, MethodKind.DATA_PROVIDER, false);
            while (methodInfo3 != null) {
                featureInfo.addDataProvider(this.createDataProvider(featureInfo, methodInfo3));
                string2 = InternalIdentifiers.getDataProviderName(method.getName(), n++);
                methodInfo3 = this.createMethod(string2, MethodKind.DATA_PROVIDER, false);
            }
        }
        for (BlockMetadata blockMetadata : featureMetadata.blocks()) {
            BlockInfo blockInfo = new BlockInfo();
            blockInfo.setKind(blockMetadata.kind());
            blockInfo.setTexts(Arrays.asList(blockMetadata.texts()));
            featureInfo.addBlock(blockInfo);
        }
        return featureInfo;
    }

    private DataProviderInfo createDataProvider(FeatureInfo featureInfo, MethodInfo methodInfo) {
        DataProviderMetadata dataProviderMetadata = ((Method)methodInfo.getReflection()).getAnnotation(DataProviderMetadata.class);
        DataProviderInfo dataProviderInfo = new DataProviderInfo();
        dataProviderInfo.setParent(featureInfo);
        dataProviderInfo.setLine(dataProviderMetadata.line());
        dataProviderInfo.setDataVariables(Arrays.asList(dataProviderMetadata.dataVariables()));
        dataProviderInfo.setDataProviderMethod(methodInfo);
        return dataProviderInfo;
    }

    private MethodInfo createMethod(String string, MethodKind methodKind, boolean bl) {
        Method method = this.findMethod(string);
        if (method == null && !bl) {
            return null;
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.spec);
        methodInfo.setName(string);
        methodInfo.setReflection(method);
        methodInfo.setKind(methodKind);
        return methodInfo;
    }

    private Method findMethod(String string) {
        for (Method method : ((Class)this.spec.getReflection()).getDeclaredMethods()) {
            if (!method.getName().equals(string)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private void buildInitializerMethods() {
        this.spec.setInitializerMethod(this.createMethod("$spock_initializeFields", MethodKind.INITIALIZER, true));
        this.spec.setSharedInitializerMethod(this.createMethod("$spock_initializeSharedFields", MethodKind.SHARED_INITIALIZER, true));
    }

    private void buildFixtureMethods() {
        this.spec.setSetupMethod(this.createMethod("setup", MethodKind.SETUP, true));
        this.spec.setCleanupMethod(this.createMethod("cleanup", MethodKind.CLEANUP, true));
        this.spec.setSetupSpecMethod(this.createMethod("setupSpec", MethodKind.SETUP_SPEC, true));
        this.spec.setCleanupSpecMethod(this.createMethod("cleanupSpec", MethodKind.CLEANUP_SPEC, true));
    }
}

