/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IoUtil;
import org.spockframework.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunHistory
implements Comparable<SpecRunHistory> {
    private static final int MAX_CONFIDENCE = 5;
    private final String specName;
    private Data data = new Data();

    public SpecRunHistory(String string) {
        this.specName = string;
    }

    public String getSpecName() {
        return this.specName;
    }

    public void loadFromDisk() throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.getDataFile()));
        try {
            this.data = (Data)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                IOException iOException = new IOException("deserialization error");
                iOException.initCause(classNotFoundException);
                throw iOException;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(objectInputStream);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(objectInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisk() throws IOException {
        File file = this.getDataFile();
        IoUtil.createDirectory(file.getParentFile());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        try {
            objectOutputStream.writeObject(this.data);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(objectOutputStream);
            throw throwable;
        }
        IoUtil.closeQuietly(objectOutputStream);
    }

    public void sortFeatures(SpecInfo specInfo) {
        specInfo.sortFeatures(new IFeatureSortOrder(){

            public int compare(FeatureInfo featureInfo, FeatureInfo featureInfo2) {
                long l;
                Integer n = ((SpecRunHistory)SpecRunHistory.this).data.featureConfidences.get(featureInfo.getName());
                if (n == null) {
                    return -1;
                }
                Integer n2 = ((SpecRunHistory)SpecRunHistory.this).data.featureConfidences.get(featureInfo2.getName());
                if (n2 == null) {
                    return 1;
                }
                if (!n.equals(n2)) {
                    return n - n2;
                }
                long l2 = ((SpecRunHistory)SpecRunHistory.this).data.featureDurations.get(featureInfo.getName());
                return l2 < (l = ((SpecRunHistory)SpecRunHistory.this).data.featureDurations.get(featureInfo2.getName()).longValue()) ? -1 : 1;
            }
        });
    }

    @Override
    public int compareTo(SpecRunHistory specRunHistory) {
        int n = this.data.specConfidence.compareTo(specRunHistory.data.specConfidence);
        if (n != 0) {
            return n;
        }
        return this.data.specDuration < specRunHistory.data.specDuration ? -1 : 1;
    }

    public void collectFeatureData(FeatureInfo featureInfo, long l, boolean bl) {
        this.data.featureDurations.put(featureInfo.getName(), l);
        Integer n = this.data.featureConfidences.get(featureInfo.getName());
        if (n == null) {
            n = 0;
        }
        int n2 = bl ? 0 : Math.min(5, n + 1);
        this.data.featureConfidences.put(featureInfo.getName(), n2);
    }

    public void collectSpecData(SpecInfo specInfo, long l) {
        this.data.specDuration = l;
        this.removeObsoleteFeaturesFromData(specInfo);
        this.computeSpecConfidence();
    }

    private void removeObsoleteFeaturesFromData(SpecInfo specInfo) {
        List<FeatureInfo> list = specInfo.getAllFeatures();
        Set<String> set = this.extractNames(list);
        this.data.featureConfidences.keySet().retainAll(set);
        this.data.featureDurations.keySet().retainAll(set);
    }

    private void computeSpecConfidence() {
        int n = 0;
        for (int n2 : this.data.featureConfidences.values()) {
            n += n2;
        }
        int n3 = this.data.featureConfidences.size();
        this.data.specConfidence = n3 == 0 ? new BigDecimal(0) : new BigDecimal(n).divide(new BigDecimal(n3), MathContext.DECIMAL32);
    }

    private Set<String> extractNames(List<FeatureInfo> list) {
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (FeatureInfo featureInfo : list) {
            hashSet.add(featureInfo.getName());
        }
        return hashSet;
    }

    private File getDataFile() {
        return new File(TextUtil.join(File.separator, System.getProperty("user.home"), ".spock", "RunHistory", this.specName));
    }

    private static class Data
    implements Serializable {
        BigDecimal specConfidence = new BigDecimal(0);
        long specDuration = 0L;
        Map<String, Integer> featureConfidences = new HashMap<String, Integer>();
        Map<String, Long> featureDurations = new HashMap<String, Long>();

        private Data() {
        }
    }
}

