/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpecRunHistory;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecUtil {
    private SpecUtil() {
    }

    public static boolean isSpec(Class<?> clazz) {
        return clazz.isAnnotationPresent(SpecMetadata.class);
    }

    public static void checkIsSpec(Class<?> clazz) {
        if (SpecUtil.isSpec(clazz)) {
            return;
        }
        if (Specification.class.isAssignableFrom(clazz)) {
            throw new InvalidSpecException("Specification '%s' was not compiled properly (Spock AST transform was not run); try to do a clean build").withArgs(clazz.getName());
        }
        throw new InvalidSpecException("Class '%s' is not a Spock specification (does not extend spock.lang.Specification or a subclass thereof)").withArgs(clazz.getName());
    }

    public static boolean isRunnableSpec(Class<?> clazz) {
        return SpecUtil.isSpec(clazz) && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static void checkIsRunnableSpec(Class<?> clazz) {
        SpecUtil.checkIsSpec(clazz);
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new InvalidSpecException("Specification '%s' is not runnable because it is declared abstract").withArgs(clazz.getName());
        }
    }

    public static int getFeatureCount(Class<?> clazz) {
        SpecUtil.checkIsSpec(clazz);
        int n = 0;
        do {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(FeatureMetadata.class)) continue;
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null && SpecUtil.isSpec(clazz));
        return n;
    }

    public static List<String> optimizeRunOrder(List<String> list) {
        List<SpecRunHistory> list2 = SpecUtil.loadHistories(list);
        Collections.sort(list2);
        return SpecUtil.extractNames(list2);
    }

    public static <T> T getConfiguration(Class<T> clazz) {
        return RunContext.get().getConfiguration(clazz);
    }

    private static List<SpecRunHistory> loadHistories(List<String> list) {
        ArrayList<SpecRunHistory> arrayList = new ArrayList<SpecRunHistory>(list.size());
        for (String string : list) {
            SpecRunHistory specRunHistory = new SpecRunHistory(string);
            try {
                specRunHistory.loadFromDisk();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add(specRunHistory);
        }
        return arrayList;
    }

    private static List<String> extractNames(List<SpecRunHistory> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (SpecRunHistory specRunHistory : list) {
            arrayList.add(specRunHistory.getSpecName());
        }
        return arrayList;
    }
}

