/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.ListIterator;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.HamcrestFacade;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.util.GroovyRuntimeUtil;
import spock.util.matcher.HamcrestSupport;

public abstract class SpockRuntime {
    public static final String VERIFY_CONDITION = "verifyCondition";
    public static final String VERIFY_METHOD_CONDITION = "verifyMethodCondition";
    public static final String DESPREAD_LIST = "despreadList";

    public static void verifyCondition(ValueRecorder valueRecorder, String string, int n, int n2, Object object, Object object2) {
        if (!GroovyRuntimeUtil.isTruthy(object2)) {
            throw new ConditionNotSatisfiedError(new Condition(valueRecorder, string, TextPosition.create(n, n2), SpockRuntime.messageToString(object)));
        }
    }

    public static void verifyMethodCondition(ValueRecorder valueRecorder, String string, int n, int n2, Object object, Object object2, String string2, Object[] objectArray, boolean bl, boolean bl2) {
        Object object3;
        MatcherCondition matcherCondition = MatcherCondition.parse(object2, string2, objectArray, bl);
        if (matcherCondition != null) {
            matcherCondition.verify(valueRecorder, string, n, n2, SpockRuntime.messageToString(object));
            return;
        }
        Object object4 = object3 = bl ? GroovyRuntimeUtil.invokeMethodNullSafe(object2, string2, objectArray) : GroovyRuntimeUtil.invokeMethod(object2, string2, objectArray);
        if (valueRecorder != null) {
            valueRecorder.replaceLastValue(object3);
        }
        if (!bl2 && object3 == null && GroovyRuntimeUtil.isVoidMethod(object2, string2, objectArray)) {
            return;
        }
        if (!GroovyRuntimeUtil.isTruthy(object3)) {
            throw new ConditionNotSatisfiedError(new Condition(valueRecorder, string, TextPosition.create(n, n2), SpockRuntime.messageToString(object)));
        }
    }

    public static Object[] despreadList(Object[] objectArray, Object[] objectArray2, int[] nArray) {
        return GroovyRuntimeUtil.despreadList(objectArray, objectArray2, nArray);
    }

    private static String messageToString(Object object) {
        if (object == null) {
            return null;
        }
        return GroovyRuntimeUtil.toString(object);
    }

    private static class MatcherCondition {
        final Object actual;
        final Object matcher;
        final boolean shortSyntax;

        MatcherCondition(Object object, Object object2, boolean bl) {
            this.actual = object;
            this.matcher = object2;
            this.shortSyntax = bl;
        }

        void verify(ValueRecorder valueRecorder, String string, int n, int n2, String string2) {
            if (HamcrestFacade.matches(this.matcher, this.actual)) {
                return;
            }
            if (valueRecorder != null) {
                valueRecorder.replaceLastValue(this.shortSyntax ? this.actual : Boolean.valueOf(false));
                this.replaceMatcherValues(valueRecorder);
            }
            String string3 = HamcrestFacade.getFailureDescription(this.matcher, this.actual, string2);
            Condition condition = new Condition(valueRecorder, string, TextPosition.create(n, n2), string3);
            throw new ConditionNotSatisfiedError(condition);
        }

        void replaceMatcherValues(ValueRecorder valueRecorder) {
            boolean bl = true;
            List<Object> list = valueRecorder.getRecordedValues();
            ListIterator<Object> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object object = listIterator.previous();
                if (!HamcrestFacade.isMatcher(object)) continue;
                if (bl) {
                    listIterator.set(this.shortSyntax ? Boolean.valueOf(false) : ExpressionInfo.VALUE_NOT_AVAILABLE);
                    bl = false;
                    continue;
                }
                listIterator.set(ExpressionInfo.VALUE_NOT_AVAILABLE);
            }
        }

        static MatcherCondition parse(Object object, String string, Object[] objectArray, boolean bl) {
            if (bl) {
                return null;
            }
            if (string.equals("call")) {
                if (objectArray.length != 1 || !HamcrestFacade.isMatcher(objectArray[0])) {
                    return null;
                }
                return new MatcherCondition(object, objectArray[0], true);
            }
            if (string.equals("that")) {
                if (object != HamcrestSupport.class) {
                    return null;
                }
                if (objectArray.length != 2 || !HamcrestFacade.isMatcher(objectArray[1])) {
                    return null;
                }
                return new MatcherCondition(objectArray[0], objectArray[1], false);
            }
            return null;
        }
    }
}

