/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.util.InternalIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceFilter
implements IStackTraceFilter {
    private static final Pattern FILTERED_CLASSES = Pattern.compile("org.codehaus.groovy.runtime\\..*|org.codehaus.groovy.reflection\\..*|org.codehaus.groovy\\..*MetaClass.*|groovy\\..*MetaClass.*|groovy.lang.MetaMethod|java.lang.reflect\\..*|sun.reflect\\..*|org.spockframework.runtime\\.[^\\.]+");
    private static final Pattern CLOSURE_CLASS = Pattern.compile("(.+)\\$_(.+)_closure(\\d+)");
    private final IMethodNameMapper mapper;

    public StackTraceFilter(IMethodNameMapper iMethodNameMapper) {
        this.mapper = iMethodNameMapper;
    }

    @Override
    public void filter(Throwable throwable) {
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (this.isInitializerOrFixtureMethod(stackTraceElement)) {
                arrayList.add(stackTraceElement);
                break;
            }
            if (this.checkForAndAddPrettyPrintedFeatureMethod(stackTraceElement, arrayList)) break;
            if (StackTraceFilter.isFilteredClass(stackTraceElement) || this.checkForAndAddPrettyPrintedClosureInvocation(stackTraceElement, arrayList) || this.isGeneratedMethod(stackTraceElement)) continue;
            arrayList.add(stackTraceElement);
        }
        throwable.setStackTrace(arrayList.toArray(new StackTraceElement[arrayList.size()]));
        if (throwable.getCause() != null) {
            this.filter(throwable.getCause());
        }
    }

    private boolean isInitializerOrFixtureMethod(StackTraceElement stackTraceElement) {
        return this.mapper.isInitializerOrFixtureMethod(stackTraceElement.getClassName(), stackTraceElement.getMethodName());
    }

    private static boolean isFilteredClass(StackTraceElement stackTraceElement) {
        return FILTERED_CLASSES.matcher(stackTraceElement.getClassName()).matches();
    }

    private boolean checkForAndAddPrettyPrintedFeatureMethod(StackTraceElement stackTraceElement, List<StackTraceElement> list) {
        if (!InternalIdentifiers.isFeatureMethodName(stackTraceElement.getMethodName())) {
            return false;
        }
        list.add(this.prettyPrintFeatureMethod(stackTraceElement));
        return true;
    }

    private StackTraceElement prettyPrintFeatureMethod(StackTraceElement stackTraceElement) {
        return new StackTraceElement(stackTraceElement.getClassName(), this.mapper.toFeatureName(stackTraceElement.getMethodName()), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
    }

    private boolean checkForAndAddPrettyPrintedClosureInvocation(StackTraceElement stackTraceElement, List<StackTraceElement> list) {
        if (!stackTraceElement.getMethodName().equals("doCall")) {
            return false;
        }
        Matcher matcher = CLOSURE_CLASS.matcher(stackTraceElement.getClassName());
        if (!matcher.matches()) {
            return false;
        }
        list.add(this.prettyPrintClosureInvocation(stackTraceElement, matcher));
        return true;
    }

    private StackTraceElement prettyPrintClosureInvocation(StackTraceElement stackTraceElement, Matcher matcher) {
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        String string4 = string;
        String string5 = this.mapper.toFeatureName(string2) + "_closure" + string3;
        return new StackTraceElement(string4, string5, stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
    }

    private boolean isGeneratedMethod(StackTraceElement stackTraceElement) {
        return stackTraceElement.getLineNumber() < 0;
    }
}

