/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.condition;

import java.util.LinkedList;
import java.util.List;
import org.spockframework.runtime.condition.EditOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDistance {
    private final CharSequence seq1;
    private final CharSequence seq2;
    private final int[][] matrix;

    public EditDistance(CharSequence charSequence, CharSequence charSequence2) {
        this.seq1 = charSequence;
        this.seq2 = charSequence2;
        this.matrix = new int[charSequence.length() + 1][];
        this.calculateMatrix();
    }

    private void calculateMatrix() {
        for (int i = 0; i < this.seq1.length() + 1; ++i) {
            this.matrix[i] = new int[this.seq2.length() + 1];
            for (int j = 0; j < this.seq2.length() + 1; ++j) {
                this.matrix[i][j] = i == 0 ? j : (j == 0 ? i : EditDistance.min(this.matrix[i][j - 1] + 1, this.matrix[i - 1][j] + 1, this.matrix[i - 1][j - 1] + (this.seq1.charAt(i - 1) == this.seq2.charAt(j - 1) ? 0 : 1)));
            }
        }
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getDistance() {
        return this.matrix[this.seq1.length()][this.seq2.length()];
    }

    public int getSimilarityInPercent() {
        int n = Math.max(this.seq1.length(), this.seq2.length());
        return (n - this.getDistance()) * 100 / n;
    }

    public List<EditOperation> calculatePath() {
        LinkedList<EditOperation> linkedList = new LinkedList<EditOperation>();
        int n = this.seq1.length();
        int n2 = this.seq2.length();
        int n3 = this.matrix[n][n2];
        while (n > 0 && n2 > 0 && n3 > 0) {
            int n4 = this.matrix[n][n2 - 1];
            int n5 = this.matrix[n - 1][n2];
            int n6 = this.matrix[n - 1][n2 - 1];
            if (n3 == n4 + 1) {
                this.addOrUpdate(linkedList, EditOperation.Kind.INSERT, 1);
                --n2;
            } else if (n3 == n5 + 1) {
                this.addOrUpdate(linkedList, EditOperation.Kind.DELETE, 1);
                --n;
            } else {
                if (n3 == n6) {
                    this.addOrUpdate(linkedList, EditOperation.Kind.SKIP, 1);
                } else {
                    this.addOrUpdate(linkedList, EditOperation.Kind.SUBSTITUTE, 1);
                }
                --n;
                --n2;
            }
            n3 = this.matrix[n][n2];
        }
        if (n == 0) {
            this.addOrUpdate(linkedList, EditOperation.Kind.INSERT, n2);
        } else if (n2 == 0) {
            this.addOrUpdate(linkedList, EditOperation.Kind.DELETE, n);
        } else {
            this.addOrUpdate(linkedList, EditOperation.Kind.SKIP, n);
        }
        return linkedList;
    }

    private void addOrUpdate(LinkedList<EditOperation> linkedList, EditOperation.Kind kind, int n) {
        if (n == 0) {
            return;
        }
        if (!linkedList.isEmpty() && linkedList.getFirst().getKind() == kind) {
            linkedList.getFirst().incLength(n);
        } else {
            linkedList.addFirst(new EditOperation(kind, n));
        }
    }

    private static int min(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }
}

