/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.condition;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.condition.IObjectRendererService;
import org.spockframework.util.InternalSpockError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRendererService
implements IObjectRendererService {
    private final HashMap<Class<?>, IObjectRenderer<?>> renderers = new HashMap();

    @Override
    public <T> void addRenderer(Class<T> clazz, IObjectRenderer<? super T> iObjectRenderer) {
        this.renderers.put(clazz, iObjectRenderer);
    }

    @Override
    public String render(Object object) {
        if (object == null) {
            return "null\n";
        }
        Set<Class<?>> set = Collections.singleton(object.getClass());
        while (!set.isEmpty()) {
            for (Class clazz : set) {
                IObjectRenderer<?> iObjectRenderer = this.renderers.get(clazz);
                if (iObjectRenderer == null) continue;
                return iObjectRenderer.render(object);
            }
            set = this.getParents(set);
        }
        IObjectRenderer<?> iObjectRenderer = this.renderers.get(Object.class);
        if (iObjectRenderer != null) {
            return iObjectRenderer.render(object);
        }
        throw new InternalSpockError("no renderer for type Object found");
    }

    private Set<Class<?>> getParents(Set<Class<?>> set) {
        HashSet hashSet = new HashSet();
        for (Class<?> clazz : set) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != Object.class) {
                hashSet.add(clazz2);
            }
            hashSet.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        return hashSet;
    }
}

