/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.util.UnreachableCodeError;

public abstract class AbstractMethodInterceptor
implements IMethodInterceptor {
    public final void intercept(IMethodInvocation iMethodInvocation) throws Throwable {
        switch (iMethodInvocation.getMethod().getKind()) {
            case INITIALIZER: {
                this.interceptInitializerMethod(iMethodInvocation);
                break;
            }
            case SHARED_INITIALIZER: {
                this.interceptSharedInitializerMethod(iMethodInvocation);
                break;
            }
            case SETUP: {
                this.interceptSetupMethod(iMethodInvocation);
                break;
            }
            case CLEANUP: {
                this.interceptCleanupMethod(iMethodInvocation);
                break;
            }
            case SETUP_SPEC: {
                this.interceptSetupSpecMethod(iMethodInvocation);
                break;
            }
            case CLEANUP_SPEC: {
                this.interceptCleanupSpecMethod(iMethodInvocation);
                break;
            }
            case FEATURE: {
                this.interceptFeatureMethod(iMethodInvocation);
                break;
            }
            case DATA_PROVIDER: {
                this.interceptDataProviderMethod(iMethodInvocation);
                break;
            }
            case DATA_PROCESSOR: {
                this.interceptDataProcessorMethod(iMethodInvocation);
                break;
            }
            case ITERATION_EXECUTION: {
                this.interceptIterationExecution(iMethodInvocation);
                break;
            }
            case SPEC_EXECUTION: {
                this.interceptSpecExecution(iMethodInvocation);
                break;
            }
            case FEATURE_EXECUTION: {
                this.interceptFeatureExecution(iMethodInvocation);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
    }

    public void interceptInitializerMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptSharedInitializerMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptSetupMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptCleanupMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptSetupSpecMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptCleanupSpecMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptFeatureMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptDataProviderMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptDataProcessorMethod(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptIterationExecution(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptSpecExecution(IMethodInvocation iMethodInvocation) throws Throwable {
    }

    public void interceptFeatureExecution(IMethodInvocation iMethodInvocation) throws Throwable {
    }
}

