/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;

public class MethodInvocation
implements IMethodInvocation {
    private final FeatureInfo feature;
    private final IterationInfo iteration;
    private final Object sharedInstance;
    private final Object instance;
    private final Object target;
    private final MethodInfo method;
    private final Object[] arguments;
    private final Iterator<IMethodInterceptor> interceptors;

    public MethodInvocation(FeatureInfo featureInfo, IterationInfo iterationInfo, Object object, Object object2, Object object3, MethodInfo methodInfo, Object[] objectArray) {
        this.feature = featureInfo;
        this.iteration = iterationInfo;
        this.sharedInstance = object;
        this.instance = object2;
        this.target = object3;
        this.method = methodInfo;
        this.arguments = objectArray;
        this.interceptors = methodInfo.getInterceptors().iterator();
    }

    public SpecInfo getSpec() {
        return (SpecInfo)this.method.getParent();
    }

    public FeatureInfo getFeature() {
        return this.feature;
    }

    public IterationInfo getIteration() {
        return this.iteration;
    }

    public Object getSharedInstance() {
        return this.sharedInstance;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object getTarget() {
        return this.target;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void proceed() throws Throwable {
        if (this.interceptors.hasNext()) {
            this.interceptors.next().intercept(this);
        } else {
            this.invokeTargetMethod();
        }
    }

    protected void invokeTargetMethod() throws Throwable {
        if (this.method.isStub()) {
            return;
        }
        ReflectionUtil.invokeMethod(this.target, (Method)this.method.getReflection(), this.arguments);
    }
}

