/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.AutoCleanupInterceptor;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.AutoCleanup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCleanupExtension
extends AbstractAnnotationDrivenExtension<AutoCleanup> {
    private final AutoCleanupInterceptor sharedFieldInterceptor = new AutoCleanupInterceptor();
    private final AutoCleanupInterceptor instanceFieldInterceptor = new AutoCleanupInterceptor();

    @Override
    public void visitFieldAnnotation(AutoCleanup autoCleanup, FieldInfo fieldInfo) {
        if (fieldInfo.isShared()) {
            this.sharedFieldInterceptor.add(fieldInfo);
        } else {
            this.instanceFieldInterceptor.add(fieldInfo);
        }
    }

    @Override
    public void visitSpec(SpecInfo specInfo) {
        this.sharedFieldInterceptor.install(specInfo.getTopSpec().getCleanupSpecMethod());
        this.instanceFieldInterceptor.install(specInfo.getTopSpec().getCleanupMethod());
    }
}

