/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.extension.ExtensionUtil;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.util.GroovyRuntimeUtil;
import spock.lang.AutoCleanup;

public class AutoCleanupInterceptor
implements IMethodInterceptor {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();

    public void add(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    public void install(MethodInfo methodInfo) {
        if (this.fields.isEmpty()) {
            return;
        }
        Collections.reverse(this.fields);
        methodInfo.addInterceptor(this);
    }

    public void intercept(IMethodInvocation iMethodInvocation) throws Throwable {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            iMethodInvocation.proceed();
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
        }
        for (FieldInfo fieldInfo : this.fields) {
            AutoCleanup autoCleanup = fieldInfo.getAnnotation(AutoCleanup.class);
            try {
                Object object = fieldInfo.readValue(iMethodInvocation.getTarget());
                if (object == null) continue;
                GroovyRuntimeUtil.invokeMethod(object, autoCleanup.value(), new Object[0]);
            }
            catch (Throwable throwable) {
                if (autoCleanup.quiet()) continue;
                arrayList.add(throwable);
            }
        }
        ExtensionUtil.throwAll(arrayList);
    }
}

