/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.builtin.AbstractRuleExtension;
import org.spockframework.runtime.extension.builtin.ClassRuleInterceptor;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class ClassRuleExtension
extends AbstractRuleExtension {
    public void visitSpec(SpecInfo specInfo) {
        if (classRuleClass == null) {
            return;
        }
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : specInfo.getAllFields()) {
            if (!fieldInfo.isAnnotationPresent(classRuleClass)) continue;
            this.checkIsSharedField(fieldInfo);
            if (this.hasFieldType(fieldInfo, testRuleClass)) {
                arrayList.add(fieldInfo);
                continue;
            }
            this.invalidFieldType(fieldInfo);
        }
        if (!arrayList.isEmpty()) {
            ClassRuleInterceptorInstaller.install(specInfo, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassRuleInterceptorInstaller {
        private ClassRuleInterceptorInstaller() {
        }

        static void install(SpecInfo specInfo, List<FieldInfo> list) {
            specInfo.addInterceptor(new ClassRuleInterceptor(list));
        }
    }
}

