/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfineMetaClassChangesInterceptor
implements IMethodInterceptor {
    private final Collection<Class<?>> classes;
    private final List<MetaClass> originalMetaClasses = new ArrayList<MetaClass>();

    public ConfineMetaClassChangesInterceptor(Collection<Class<?>> collection) {
        this.classes = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(IMethodInvocation iMethodInvocation) throws Throwable {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        for (Class<?> metaClass : this.classes) {
            this.originalMetaClasses.add(metaClassRegistry.getMetaClass(metaClass));
            ExpandoMetaClass expandoMetaClass = new ExpandoMetaClass(metaClass, true, true);
            expandoMetaClass.initialize();
            metaClassRegistry.setMetaClass(metaClass, (MetaClass)expandoMetaClass);
        }
        try {
            iMethodInvocation.proceed();
        }
        catch (Throwable throwable) {
            for (MetaClass metaClass : this.originalMetaClasses) {
                metaClassRegistry.setMetaClass(metaClass.getTheClass(), metaClass);
            }
            throw throwable;
        }
        for (MetaClass metaClass : this.originalMetaClasses) {
            metaClassRegistry.setMetaClass(metaClass.getTheClass(), metaClass);
        }
    }
}

