/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.IncludeExcludeCriteria;
import spock.config.RunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeExcludeExtension
implements IGlobalExtension {
    private RunnerConfiguration config;

    @Override
    public void visitSpec(SpecInfo specInfo) {
        this.handleSpecIncludes(specInfo, this.config.include);
        this.handleSpecExcludes(specInfo, this.config.exclude);
        if (specInfo.isExcluded()) {
            this.excludeAllFeatures(specInfo);
        }
        this.handleFeatureIncludes(specInfo, this.config.include);
        this.handleFeatureExcludes(specInfo, this.config.exclude);
        if (specInfo.isExcluded() && !this.allFeaturesExcluded(specInfo)) {
            specInfo.setExcluded(false);
        }
    }

    private void handleSpecIncludes(SpecInfo specInfo, IncludeExcludeCriteria includeExcludeCriteria) {
        if (includeExcludeCriteria.isEmpty()) {
            return;
        }
        if (!this.hasAnyAnnotation(specInfo, includeExcludeCriteria.annotations) && !this.hasAnyBaseClass(specInfo, includeExcludeCriteria.baseClasses)) {
            specInfo.setExcluded(true);
        }
    }

    private void handleSpecExcludes(SpecInfo specInfo, IncludeExcludeCriteria includeExcludeCriteria) {
        if (includeExcludeCriteria.isEmpty()) {
            return;
        }
        if (this.hasAnyAnnotation(specInfo, includeExcludeCriteria.annotations) || this.hasAnyBaseClass(specInfo, includeExcludeCriteria.baseClasses)) {
            specInfo.setExcluded(true);
        }
    }

    private void handleFeatureIncludes(SpecInfo specInfo, IncludeExcludeCriteria includeExcludeCriteria) {
        if (includeExcludeCriteria.isEmpty()) {
            return;
        }
        for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
            if (!this.hasAnyAnnotation(featureInfo.getFeatureMethod(), includeExcludeCriteria.annotations)) continue;
            featureInfo.setExcluded(false);
        }
    }

    private void handleFeatureExcludes(SpecInfo specInfo, IncludeExcludeCriteria includeExcludeCriteria) {
        if (includeExcludeCriteria.isEmpty()) {
            return;
        }
        for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
            if (!this.hasAnyAnnotation(featureInfo.getFeatureMethod(), includeExcludeCriteria.annotations)) continue;
            featureInfo.setExcluded(true);
        }
    }

    private void excludeAllFeatures(SpecInfo specInfo) {
        for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
            featureInfo.setExcluded(true);
        }
    }

    private boolean allFeaturesExcluded(SpecInfo specInfo) {
        for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
            if (featureInfo.isExcluded()) continue;
            return false;
        }
        return true;
    }

    private boolean hasAnyAnnotation(NodeInfo<?, ?> nodeInfo, List<Class<? extends Annotation>> list) {
        for (Class<? extends Annotation> clazz : list) {
            if (!nodeInfo.getReflection().isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyBaseClass(SpecInfo specInfo, List<Class<?>> list) {
        for (Class<?> clazz : list) {
            if (!clazz.isAssignableFrom((Class)specInfo.getReflection())) continue;
            return true;
        }
        return false;
    }
}

