/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;
import org.spockframework.util.UnreachableCodeError;

public class JUnitFixtureMethodsExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo specInfo) {
        FixtureType.addInterceptors(specInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FixtureType {
        BEFORE(Before.class, false, MethodKind.SETUP, true),
        AFTER(After.class, false, MethodKind.CLEANUP, false),
        BEFORE_CLASS(BeforeClass.class, true, MethodKind.SETUP_SPEC, true),
        AFTER_CLASS(AfterClass.class, true, MethodKind.CLEANUP_SPEC, false);

        public final Class<? extends Annotation> annotationType;
        public final boolean isStatic;
        public final MethodKind interceptedMethodKind;
        public final boolean executeBeforeSpecMethod;

        private FixtureType(Class<? extends Annotation> clazz, boolean bl, MethodKind methodKind, boolean bl2) {
            this.annotationType = clazz;
            this.isStatic = bl;
            this.interceptedMethodKind = methodKind;
            this.executeBeforeSpecMethod = bl2;
        }

        private void addInterceptor(SpecInfo specInfo, Collection<Method> collection) {
            LinkedList<Method> linkedList = new LinkedList<Method>();
            for (Method method : collection) {
                if (!this.isMethod(method)) continue;
                linkedList.add(method);
            }
            if (!linkedList.isEmpty()) {
                this.getInterceptedMethod(specInfo).addInterceptor(new FixtureMethodInterceptor(linkedList));
            }
        }

        private MethodInfo getInterceptedMethod(SpecInfo specInfo) {
            for (MethodInfo methodInfo : specInfo.getFixtureMethods()) {
                if (!methodInfo.getKind().equals((Object)this.interceptedMethodKind)) continue;
                return methodInfo;
            }
            throw new UnreachableCodeError("failed to find fixture method of kind " + (Object)((Object)this.interceptedMethodKind));
        }

        private boolean isMethod(Method method) {
            boolean bl = method.getAnnotation(this.annotationType) != null && Modifier.isStatic(method.getModifiers()) == this.isStatic;
            return bl;
        }

        public static boolean isPotentialMethod(Method method) {
            boolean bl = method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0 && Modifier.isPublic(method.getModifiers());
            return bl;
        }

        public static void addInterceptors(SpecInfo specInfo) {
            for (SpecInfo specInfo2 : specInfo.getSpecsBottomToTop()) {
                LinkedList<Method> linkedList = new LinkedList<Method>();
                for (Method method : ((Class)specInfo2.getReflection()).getDeclaredMethods()) {
                    if (!FixtureType.isPotentialMethod(method)) continue;
                    linkedList.add(method);
                }
                if (linkedList.isEmpty()) continue;
                for (FixtureType fixtureType : FixtureType.values()) {
                    fixtureType.addInterceptor(specInfo2, linkedList);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FixtureMethodInterceptor
        implements IMethodInterceptor {
            private final Collection<Method> methods;

            public FixtureMethodInterceptor(Collection<Method> collection) {
                this.methods = collection;
            }

            @Override
            public void intercept(IMethodInvocation iMethodInvocation) throws Throwable {
                if (!FixtureType.this.executeBeforeSpecMethod) {
                    iMethodInvocation.proceed();
                }
                for (Method method : this.methods) {
                    ReflectionUtil.invokeMethod(iMethodInvocation.getTarget(), method, new Object[0]);
                }
                if (FixtureType.this.executeBeforeSpecMethod) {
                    iMethodInvocation.proceed();
                }
            }
        }
    }
}

