/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.IOException;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.SpecRunHistory;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

public class OptimizeRunOrderExtension
implements IGlobalExtension {
    private RunnerConfiguration configuration;

    public void visitSpec(SpecInfo specInfo) {
        if (!this.configuration.optimizeRunOrder) {
            return;
        }
        final SpecRunHistory specRunHistory = new SpecRunHistory(((Class)specInfo.getReflection()).getName());
        this.safeLoadFromDisk(specRunHistory);
        specRunHistory.sortFeatures(specInfo);
        specInfo.addListener(new AbstractRunListener(){
            long specStarted;
            long featureStarted;
            boolean errorOccurred;

            public void beforeSpec(SpecInfo specInfo) {
                this.specStarted = System.nanoTime();
            }

            public void beforeFeature(FeatureInfo featureInfo) {
                this.featureStarted = System.nanoTime();
                this.errorOccurred = false;
            }

            public void afterFeature(FeatureInfo featureInfo) {
                specRunHistory.collectFeatureData(featureInfo, System.nanoTime() - this.featureStarted, this.errorOccurred);
            }

            public void error(ErrorInfo errorInfo) {
                this.errorOccurred = true;
            }

            public void afterSpec(SpecInfo specInfo) {
                specRunHistory.collectSpecData(specInfo, System.nanoTime() - this.specStarted);
                OptimizeRunOrderExtension.this.safeSaveToDisk(specRunHistory);
            }
        });
    }

    private void safeLoadFromDisk(SpecRunHistory specRunHistory) {
        try {
            specRunHistory.loadFromDisk();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void safeSaveToDisk(SpecRunHistory specRunHistory) {
        try {
            specRunHistory.saveToDisk();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

