/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertMetaClassRunListener
extends AbstractRunListener {
    private final Map<Class<?>, MetaClass> specLevelSavedMetaClasses = new HashMap();
    private final Map<Class<?>, MetaClass> methodLevelSavedMetaClasses = new HashMap();
    private final Set<Class<?>> specRestorations;
    private final Map<String, Set<Class<?>>> methodRestorations;

    public RevertMetaClassRunListener(Set<Class<?>> set, Map<String, Set<Class<?>>> map) {
        this.specRestorations = set;
        this.methodRestorations = map;
    }

    @Override
    public void beforeSpec(SpecInfo specInfo) {
        if (this.specRestorations.isEmpty()) {
            return;
        }
        this.saveMetaClassesInto(this.specRestorations, this.specLevelSavedMetaClasses);
    }

    @Override
    public void beforeFeature(FeatureInfo featureInfo) {
        if (featureInfo.isParameterized()) {
            return;
        }
        if (this.methodRestorations.isEmpty()) {
            return;
        }
        String string = ((Method)featureInfo.getFeatureMethod().getReflection()).getName();
        if (!this.methodRestorations.containsKey(string)) {
            return;
        }
        this.saveMetaClassesInto(this.methodRestorations.get(string), this.methodLevelSavedMetaClasses);
    }

    @Override
    public void beforeIteration(IterationInfo iterationInfo) {
        if (!((FeatureInfo)iterationInfo.getParent()).isParameterized()) {
            return;
        }
        if (this.methodRestorations.isEmpty()) {
            return;
        }
        String string = ((Method)((FeatureInfo)iterationInfo.getParent()).getFeatureMethod().getReflection()).getName();
        if (!this.methodRestorations.containsKey(string)) {
            return;
        }
        this.saveMetaClassesInto(this.methodRestorations.get(string), this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterIteration(IterationInfo iterationInfo) {
        if (!((FeatureInfo)iterationInfo.getParent()).isParameterized()) {
            return;
        }
        if (this.methodLevelSavedMetaClasses.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterFeature(FeatureInfo featureInfo) {
        if (featureInfo.isParameterized()) {
            return;
        }
        if (this.methodLevelSavedMetaClasses.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.methodLevelSavedMetaClasses);
    }

    @Override
    public void afterSpec(SpecInfo specInfo) {
        if (this.specRestorations.isEmpty()) {
            return;
        }
        this.revertMetaClassesFromAndClear(this.specLevelSavedMetaClasses);
    }

    private void saveMetaClassesInto(Set<Class<?>> set, Map<Class<?>, MetaClass> map) {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        for (Class<?> clazz : set) {
            map.put(clazz, metaClassRegistry.getMetaClass(clazz));
            ExpandoMetaClass expandoMetaClass = new ExpandoMetaClass(clazz, true, true);
            expandoMetaClass.initialize();
            metaClassRegistry.setMetaClass(clazz, (MetaClass)expandoMetaClass);
        }
    }

    private void revertMetaClassesFromAndClear(Map<Class<?>, MetaClass> map) {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        for (Map.Entry<Class<?>, MetaClass> entry : map.entrySet()) {
            Class<?> clazz = entry.getKey();
            MetaClass metaClass = entry.getValue();
            metaClassRegistry.removeMetaClass(clazz);
            metaClassRegistry.setMetaClass(clazz, metaClass);
        }
        map.clear();
    }
}

