/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.builtin.AbstractRuleExtension;
import org.spockframework.runtime.extension.builtin.MethodRuleInterceptor;
import org.spockframework.runtime.extension.builtin.TestRuleInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class RuleExtension
extends AbstractRuleExtension {
    public void visitSpec(SpecInfo specInfo) {
        if (ruleClass == null) {
            return;
        }
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> arrayList2 = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : specInfo.getAllFields()) {
            if (!fieldInfo.isAnnotationPresent(ruleClass)) continue;
            this.checkIsInstanceField(fieldInfo);
            if (this.hasFieldType(fieldInfo, methodRuleClass)) {
                arrayList.add(fieldInfo);
                continue;
            }
            if (this.hasFieldType(fieldInfo, testRuleClass)) {
                arrayList2.add(fieldInfo);
                continue;
            }
            this.invalidFieldType(fieldInfo);
        }
        if (!arrayList.isEmpty()) {
            MethodRuleInterceptorInstaller.install(specInfo, arrayList);
        }
        if (!arrayList2.isEmpty()) {
            TestRuleInterceptorInstaller.install(specInfo, arrayList2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestRuleInterceptorInstaller {
        private TestRuleInterceptorInstaller() {
        }

        static void install(SpecInfo specInfo, List<FieldInfo> list) {
            TestRuleInterceptor testRuleInterceptor = new TestRuleInterceptor(list);
            for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
                featureInfo.addIterationInterceptor(testRuleInterceptor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodRuleInterceptorInstaller {
        private MethodRuleInterceptorInstaller() {
        }

        static void install(SpecInfo specInfo, List<FieldInfo> list) {
            MethodRuleInterceptor methodRuleInterceptor = new MethodRuleInterceptor(list);
            for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
                featureInfo.getFeatureMethod().addInterceptor(methodRuleInterceptor);
            }
        }
    }
}

