/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class StepwiseExtension
extends AbstractAnnotationDrivenExtension {
    public void visitSpecAnnotation(Annotation annotation, SpecInfo specInfo) {
        this.sortFeaturesInDeclarationOrder(specInfo);
        this.includeFeaturesBeforeLastIncludedFeature(specInfo);
        this.skipFeaturesAfterFirstFailingFeature(specInfo);
    }

    private void sortFeaturesInDeclarationOrder(SpecInfo specInfo) {
        for (FeatureInfo featureInfo : specInfo.getFeatures()) {
            featureInfo.setExecutionOrder(featureInfo.getDeclarationOrder());
        }
    }

    private void includeFeaturesBeforeLastIncludedFeature(SpecInfo specInfo) {
        List<FeatureInfo> list = specInfo.getFeatures();
        boolean bl = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            FeatureInfo featureInfo = list.get(i);
            if (bl) {
                featureInfo.setExcluded(false);
                continue;
            }
            if (featureInfo.isExcluded()) continue;
            bl = true;
        }
    }

    private void skipFeaturesAfterFirstFailingFeature(final SpecInfo specInfo) {
        specInfo.getBottomSpec().addListener(new AbstractRunListener(){

            public void error(ErrorInfo errorInfo) {
                if (!((SpecInfo)errorInfo.getMethod().getParent()).equals(specInfo)) {
                    return;
                }
                for (FeatureInfo featureInfo : specInfo.getFeatures()) {
                    featureInfo.setSkipped(true);
                }
            }
        });
    }
}

