/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import spock.lang.Timeout;

public class TimeoutInterceptor
implements IMethodInterceptor {
    private final Timeout timeout;

    public TimeoutInterceptor(Timeout timeout) {
        this.timeout = timeout;
    }

    public void intercept(final IMethodInvocation iMethodInvocation) throws Throwable {
        final Thread thread = Thread.currentThread();
        final SynchronousQueue synchronousQueue = new SynchronousQueue();
        new Thread(String.format("[spock.lang.Timeout] Watcher for method '%s'", iMethodInvocation.getMethod().getName())){

            public void run() {
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
                long l = TimeoutInterceptor.this.timeout.unit().toMillis(TimeoutInterceptor.this.timeout.value());
                boolean bl = false;
                while (!bl) {
                    try {
                        bl = synchronousQueue.offer(stackTraceElementArray, l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (bl) continue;
                    if (stackTraceElementArray.length == 0) {
                        stackTraceElementArray = thread.getStackTrace();
                        l = 250L;
                    } else {
                        System.out.printf("[spock.lang.Timeout] Method '%s' has not yet returned - interrupting. Next try in %1.2f seconds.\n", iMethodInvocation.getMethod().getName(), (double)(l *= 2L) / 1000.0);
                    }
                    thread.interrupt();
                }
            }
        }.start();
        Throwable throwable = null;
        try {
            iMethodInvocation.proceed();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        StackTraceElement[] stackTraceElementArray = null;
        while (stackTraceElementArray == null) {
            try {
                stackTraceElementArray = (StackTraceElement[])synchronousQueue.take();
            }
            catch (InterruptedException interruptedException) {
                throwable = interruptedException;
            }
        }
        if (stackTraceElementArray.length > 0) {
            SpockTimeoutError spockTimeoutError = new SpockTimeoutError(this.timeout.value(), this.timeout.unit(), "Method timed out after %d %s", this.timeout.value(), this.timeout.unit().toString().toLowerCase());
            spockTimeoutError.setStackTrace(stackTraceElementArray);
            throw spockTimeoutError;
        }
        if (throwable != null) {
            throw throwable;
        }
    }
}

