/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.util.GroovyRuntimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnrollNameProvider
implements NameProvider<IterationInfo> {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("#([a-zA-Z_\\$][\\w\\$\\.\\(\\)]*)");
    private final FeatureInfo feature;
    private final Matcher expressionMatcher;
    private int iterationCount;

    public UnrollNameProvider(FeatureInfo featureInfo, String string) {
        this.feature = featureInfo;
        this.expressionMatcher = EXPRESSION_PATTERN.matcher(string);
    }

    @Override
    public String getName(IterationInfo iterationInfo) {
        return this.nameFor(iterationInfo.getDataValues());
    }

    String nameFor(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this.expressionMatcher.reset();
        while (this.expressionMatcher.find()) {
            String string = this.expressionMatcher.group(1);
            String string2 = this.evaluateExpression(string, objectArray);
            this.expressionMatcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
        }
        this.expressionMatcher.appendTail(stringBuffer);
        ++this.iterationCount;
        return stringBuffer.toString();
    }

    private String evaluateExpression(String string, Object[] objectArray) {
        int n;
        Object object;
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[0];
        if (string2.equals("featureName")) {
            object = this.feature.getName();
        } else if (string2.equals("iterationCount")) {
            object = String.valueOf(this.iterationCount);
        } else {
            n = this.feature.getDataVariables().indexOf(string2);
            if (n < 0) {
                return "#Error:" + string;
            }
            object = objectArray[n];
        }
        try {
            for (n = 1; n < stringArray.length; ++n) {
                String string3 = stringArray[n];
                object = string3.endsWith("()") ? GroovyRuntimeUtil.invokeMethod(object, string3.substring(0, string3.length() - 2), new Object[0]) : GroovyRuntimeUtil.getProperty(object, string3);
            }
            return GroovyRuntimeUtil.toString(object);
        }
        catch (Exception exception) {
            return "#Error:" + string;
        }
    }
}

