/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionInfo
implements Iterable<ExpressionInfo> {
    public static final String TEXT_NOT_AVAILABLE = new String("(n/a)");
    public static final Object VALUE_NOT_AVAILABLE = new Object(){

        public String toString() {
            return "(n/a)";
        }
    };
    private TextRegion region;
    private TextPosition anchor;
    private final String operation;
    private final List<ExpressionInfo> children;
    private String text;
    private Object value;
    private String renderedValue;
    private boolean relevant = true;

    public ExpressionInfo(TextRegion textRegion, TextPosition textPosition, String string, List<ExpressionInfo> list) {
        this.region = textRegion;
        this.anchor = textPosition;
        this.operation = string;
        this.children = list;
    }

    public ExpressionInfo(TextRegion textRegion, TextPosition textPosition, String string, ExpressionInfo ... expressionInfoArray) {
        this(textRegion, textPosition, string, Arrays.asList(expressionInfoArray));
    }

    public TextRegion getRegion() {
        return this.region;
    }

    public TextPosition getAnchor() {
        return this.anchor;
    }

    public String getOperation() {
        return this.operation;
    }

    public List<ExpressionInfo> getChildren() {
        return this.children;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Object getValue() {
        return this.value;
    }

    public ExpressionInfo setValue(Object object) {
        this.value = object;
        return this;
    }

    public String getRenderedValue() {
        return this.renderedValue;
    }

    public void setRenderedValue(String string) {
        this.renderedValue = string;
    }

    public String getEffectiveRenderedValue() {
        return this.renderedValue != null ? this.renderedValue : this.text;
    }

    public boolean isRelevant() {
        return this.relevant && this.value != VALUE_NOT_AVAILABLE;
    }

    public ExpressionInfo setRelevant(boolean bl) {
        this.relevant = bl;
        return this;
    }

    public void shiftVertically(int n) {
        this.region = this.region.shiftVertically(n);
        this.anchor = this.anchor.shiftVertically(n);
    }

    @Override
    public Iterator<ExpressionInfo> iterator() {
        ArrayList<ExpressionInfo> arrayList = new ArrayList<ExpressionInfo>();
        this.collectPrefix(arrayList, false);
        return arrayList.iterator();
    }

    public Iterable<ExpressionInfo> inPrefixOrder(final boolean bl) {
        return new Iterable<ExpressionInfo>(){

            @Override
            public Iterator<ExpressionInfo> iterator() {
                ArrayList arrayList = new ArrayList();
                ExpressionInfo.this.collectPrefix(arrayList, bl);
                return arrayList.iterator();
            }
        };
    }

    public Iterable<ExpressionInfo> inPostfixOrder(final boolean bl) {
        return new Iterable<ExpressionInfo>(){

            @Override
            public Iterator<ExpressionInfo> iterator() {
                ArrayList arrayList = new ArrayList();
                ExpressionInfo.this.collectPostfix(arrayList, bl);
                return arrayList.iterator();
            }
        };
    }

    public Iterable<ExpressionInfo> inCustomOrder(boolean bl, Comparator<ExpressionInfo> comparator) {
        ArrayList<ExpressionInfo> arrayList = new ArrayList<ExpressionInfo>();
        this.collectPrefix(arrayList, bl);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public boolean isEqualityComparison() {
        return "==".equals(this.operation) && this.children.size() == 2;
    }

    public boolean isEqualityComparison(Class<?> ... classArray) {
        if (!this.isEqualityComparison()) {
            return false;
        }
        if (!ReflectionUtil.hasAnyOfTypes(this.children.get(0).getValue(), classArray)) {
            return false;
        }
        return ReflectionUtil.hasAnyOfTypes(this.children.get(1).getValue(), classArray);
    }

    private void collectPrefix(List<ExpressionInfo> list, boolean bl) {
        if (!bl || this.isRelevant()) {
            list.add(this);
        }
        for (ExpressionInfo expressionInfo : this.children) {
            expressionInfo.collectPrefix(list, bl);
        }
    }

    private void collectPostfix(List<ExpressionInfo> list, boolean bl) {
        for (ExpressionInfo expressionInfo : this.children) {
            expressionInfo.collectPostfix(list, bl);
        }
        if (!bl || this.isRelevant()) {
            list.add(this);
        }
    }
}

