/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.spockframework.runtime.IFeatureFilter;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.IExcludable;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.util.InternalIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecInfo
extends NodeInfo<NodeInfo, Class<?>>
implements IMethodNameMapper,
ISkippable,
IExcludable,
IInterceptable {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<IMethodInterceptor> interceptors = new ArrayList<IMethodInterceptor>();
    private final List<IRunListener> listeners = new ArrayList<IRunListener>();
    private String filename;
    private SpecInfo superSpec;
    private SpecInfo subSpec;
    private List<SpecInfo> specsTopToBottom;
    private List<SpecInfo> specsBottomToTop;
    private FieldInfo sharedInstanceField;
    private MethodInfo initializerMethod;
    private MethodInfo sharedInitializerMethod;
    private MethodInfo setupMethod;
    private MethodInfo cleanupMethod;
    private MethodInfo setupSpecMethod;
    private MethodInfo cleanupSpecMethod;
    private List<FeatureInfo> features = new ArrayList<FeatureInfo>();
    private boolean excluded = false;
    private boolean skipped = false;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public SpecInfo getSuperSpec() {
        return this.superSpec;
    }

    public void setSuperSpec(SpecInfo specInfo) {
        this.superSpec = specInfo;
    }

    public SpecInfo getSubSpec() {
        return this.subSpec;
    }

    public void setSubSpec(SpecInfo specInfo) {
        this.subSpec = specInfo;
    }

    public SpecInfo getTopSpec() {
        SpecInfo specInfo = this;
        while (specInfo.getSuperSpec() != null) {
            specInfo = specInfo.getSuperSpec();
        }
        return specInfo;
    }

    public boolean isTopSpec() {
        return this.superSpec == null;
    }

    public SpecInfo getBottomSpec() {
        SpecInfo specInfo = this;
        while (specInfo.getSubSpec() != null) {
            specInfo = specInfo.getSubSpec();
        }
        return specInfo;
    }

    public boolean isBottomSpec() {
        return this.subSpec == null;
    }

    public List<SpecInfo> getSpecsTopToBottom() {
        if (this.specsTopToBottom == null) {
            this.specsTopToBottom = new ArrayList<SpecInfo>();
            for (SpecInfo specInfo = this.getTopSpec(); specInfo != null; specInfo = specInfo.getSubSpec()) {
                this.specsTopToBottom.add(specInfo);
            }
        }
        return this.specsTopToBottom;
    }

    public List<SpecInfo> getSpecsBottomToTop() {
        if (this.specsBottomToTop == null) {
            this.specsBottomToTop = new ArrayList<SpecInfo>();
            for (SpecInfo specInfo = this.getBottomSpec(); specInfo != null; specInfo = specInfo.getSuperSpec()) {
                this.specsBottomToTop.add(specInfo);
            }
        }
        return this.specsBottomToTop;
    }

    public FieldInfo getSharedInstanceField() {
        return this.sharedInstanceField;
    }

    public void setSharedInstanceField(FieldInfo fieldInfo) {
        this.sharedInstanceField = fieldInfo;
    }

    public MethodInfo getInitializerMethod() {
        return this.initializerMethod;
    }

    public void setInitializerMethod(MethodInfo methodInfo) {
        this.initializerMethod = methodInfo;
    }

    public MethodInfo getSharedInitializerMethod() {
        return this.sharedInitializerMethod;
    }

    public void setSharedInitializerMethod(MethodInfo methodInfo) {
        this.sharedInitializerMethod = methodInfo;
    }

    public MethodInfo getSetupMethod() {
        return this.setupMethod;
    }

    public void setSetupMethod(MethodInfo methodInfo) {
        this.setupMethod = methodInfo;
    }

    public MethodInfo getCleanupMethod() {
        return this.cleanupMethod;
    }

    public void setCleanupMethod(MethodInfo methodInfo) {
        this.cleanupMethod = methodInfo;
    }

    public MethodInfo getSetupSpecMethod() {
        return this.setupSpecMethod;
    }

    public void setSetupSpecMethod(MethodInfo methodInfo) {
        this.setupSpecMethod = methodInfo;
    }

    public MethodInfo getCleanupSpecMethod() {
        return this.cleanupSpecMethod;
    }

    public void setCleanupSpecMethod(MethodInfo methodInfo) {
        this.cleanupSpecMethod = methodInfo;
    }

    public List<MethodInfo> getFixtureMethods() {
        return Arrays.asList(this.setupSpecMethod, this.setupMethod, this.cleanupMethod, this.cleanupSpecMethod);
    }

    public List<MethodInfo> getAllFixtureMethods() {
        if (this.superSpec == null) {
            return this.getFixtureMethods();
        }
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>(this.superSpec.getAllFixtureMethods());
        arrayList.addAll(this.getFixtureMethods());
        return arrayList;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public List<FieldInfo> getAllFields() {
        if (this.superSpec == null) {
            return this.fields;
        }
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(this.superSpec.getAllFields());
        arrayList.addAll(this.fields);
        return arrayList;
    }

    public void addField(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    public List<FeatureInfo> getFeatures() {
        return this.features;
    }

    public List<FeatureInfo> getAllFeatures() {
        if (this.superSpec == null) {
            return this.features;
        }
        ArrayList<FeatureInfo> arrayList = new ArrayList<FeatureInfo>(this.superSpec.getAllFeatures());
        arrayList.addAll(this.features);
        return arrayList;
    }

    public List<FeatureInfo> getAllFeaturesInExecutionOrder() {
        List<FeatureInfo> list = this.getAllFeatures();
        Collections.sort(list, new Comparator<FeatureInfo>(){

            @Override
            public int compare(FeatureInfo featureInfo, FeatureInfo featureInfo2) {
                return featureInfo.getExecutionOrder() - featureInfo2.getExecutionOrder();
            }
        });
        return list;
    }

    public void addFeature(FeatureInfo featureInfo) {
        this.features.add(featureInfo);
    }

    @Override
    public List<IMethodInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(IMethodInterceptor iMethodInterceptor) {
        this.interceptors.add(iMethodInterceptor);
    }

    public List<IRunListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IRunListener iRunListener) {
        this.listeners.add(iRunListener);
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void setExcluded(boolean bl) {
        this.excluded = bl;
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public void setSkipped(boolean bl) {
        this.skipped = bl;
    }

    public void filterFeatures(IFeatureFilter iFeatureFilter) {
        for (FeatureInfo featureInfo : this.getAllFeatures()) {
            if (iFeatureFilter.matches(featureInfo)) continue;
            featureInfo.setExcluded(true);
        }
    }

    public void sortFeatures(IFeatureSortOrder iFeatureSortOrder) {
        List<FeatureInfo> list = this.getAllFeatures();
        Collections.sort(list, iFeatureSortOrder);
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setExecutionOrder(i);
        }
    }

    @Override
    public boolean isInitializerOrFixtureMethod(String string, String string2) {
        if (!InternalIdentifiers.INITIALIZER_AND_FIXTURE_METHODS.contains(string2)) {
            return false;
        }
        for (SpecInfo specInfo : this.getSpecsBottomToTop()) {
            if (!((Class)specInfo.getReflection()).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toFeatureName(String string) {
        for (FeatureInfo featureInfo : this.getAllFeatures()) {
            if (!featureInfo.hasBytecodeName(string)) continue;
            return featureInfo.getName();
        }
        return string;
    }
}

