/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.syntax.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPosition
implements Comparable<TextPosition> {
    public static final TextPosition NOT_AVAILABLE = new TextPosition(-1, -1);
    private final int line;
    private final int column;

    private TextPosition(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLineIndex() {
        return this.line - 1;
    }

    public int getColumnIndex() {
        return this.column - 1;
    }

    public TextPosition shiftVertically(int n) {
        return TextPosition.create(this.line + n, this.column);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextPosition textPosition = (TextPosition)object;
        return this.line == textPosition.line && this.column == textPosition.column;
    }

    public int hashCode() {
        return this.line * 31 + this.column;
    }

    public String toString() {
        return String.format("(%d,%d)", this.line, this.column);
    }

    @Override
    public int compareTo(TextPosition textPosition) {
        if (this.line != textPosition.line) {
            return this.line - textPosition.line;
        }
        return this.column - textPosition.column;
    }

    public static TextPosition startOf(Token token) {
        return TextPosition.create(token.getStartLine(), token.getStartColumn());
    }

    public static TextPosition startOf(ASTNode aSTNode) {
        return TextPosition.create(aSTNode.getLineNumber(), aSTNode.getColumnNumber());
    }

    public static TextPosition endOf(ASTNode aSTNode) {
        return TextPosition.create(aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber());
    }

    public static TextPosition create(int n, int n2) {
        if (n < 1 || n2 < 1) {
            return NOT_AVAILABLE;
        }
        return new TextPosition(n, n2);
    }
}

