/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import org.codehaus.groovy.ast.ASTNode;
import org.spockframework.runtime.model.TextPosition;

public class TextRegion {
    public static final TextRegion NOT_AVAILABLE = new TextRegion(TextPosition.NOT_AVAILABLE, TextPosition.NOT_AVAILABLE);
    private final TextPosition start;
    private final TextPosition end;

    private TextRegion(TextPosition textPosition, TextPosition textPosition2) {
        this.start = textPosition;
        this.end = textPosition2;
    }

    public TextPosition getStart() {
        return this.start;
    }

    public TextPosition getEnd() {
        return this.end;
    }

    public boolean contains(TextPosition textPosition) {
        return textPosition.compareTo(this.start) >= 0 && textPosition.compareTo(this.end) <= 0;
    }

    public TextRegion shiftVertically(int n) {
        return TextRegion.create(this.start.shiftVertically(n), this.end.shiftVertically(n));
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextRegion textRegion = (TextRegion)object;
        return this.start.equals(textRegion.start) && this.end.equals(textRegion.end);
    }

    public int hashCode() {
        return this.start.hashCode() * 31 + this.end.hashCode();
    }

    public String toString() {
        return String.format("%s-%s", this.start, this.end);
    }

    public static TextRegion of(ASTNode aSTNode) {
        return TextRegion.create(TextPosition.startOf(aSTNode), TextPosition.endOf(aSTNode));
    }

    public static TextRegion create(TextPosition textPosition, TextPosition textPosition2) {
        if (textPosition == TextPosition.NOT_AVAILABLE || textPosition2 == TextPosition.NOT_AVAILABLE) {
            return NOT_AVAILABLE;
        }
        return new TextRegion(textPosition, textPosition2);
    }
}

