/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spockframework.util.Assert;
import org.spockframework.util.IFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtil {
    public static <E, F> ArrayList<F> filterMap(Collection<E> collection, IFunction<E, F> iFunction) {
        ArrayList<F> arrayList = new ArrayList<F>(collection.size());
        for (E e : collection) {
            F f = iFunction.apply(e);
            if (f == null) continue;
            arrayList.add(f);
        }
        return arrayList;
    }

    public static Object[] copyArray(Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2 - n];
        System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
        return objectArray2;
    }

    public static <T> T getLastElement(List<T> list) {
        Assert.that(list.size() > 0);
        return list.get(list.size() - 1);
    }

    public static <T> void setLastElement(List<T> list, T t) {
        Assert.that(list.size() > 0);
        list.set(list.size() - 1, t);
    }

    public static <T> void addLastElement(List<T> list, T t) {
        list.add(list.size(), t);
    }

    public static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator listIterator = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIterator.previous();
                    }

                    @Override
                    public void remove() {
                        listIterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Set<T> asSet(T[] TArray) {
        return new HashSet<T>(Arrays.asList(TArray));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterableArray) {
        return CollectionUtil.concat(Arrays.asList(iterableArray));
    }

    public static <T> Iterable<T> concat(final List<Iterable<? extends T>> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> iter;
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        while (this.pos < list.size()) {
                            if (this.iter == null) {
                                this.iter = ((Iterable)list.get(this.pos)).iterator();
                            }
                            if (this.iter.hasNext()) {
                                return true;
                            }
                            this.iter = null;
                            ++this.pos;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        while (this.pos < list.size()) {
                            if (this.iter == null) {
                                this.iter = ((Iterable)list.get(this.pos)).iterator();
                            }
                            if (this.iter.hasNext()) {
                                return this.iter.next();
                            }
                            this.iter = null;
                            ++this.pos;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }
}

