/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spockframework.util.IMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter<T> {
    private final IMatcher<T> matcher;

    private Filter(IMatcher<T> iMatcher) {
        this.matcher = iMatcher;
    }

    public List<T> filter(List<? extends T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            if (!this.matcher.matches(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public void filterInPlace(List<? extends T> list) {
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.matcher.matches(iterator.next())) continue;
            iterator.remove();
        }
    }

    public static <T> Filter<T> create(IMatcher<T> iMatcher) {
        return new Filter<T>(iMatcher);
    }
}

