/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class IoUtil {
    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(Reader reader) throws IOException {
        String string;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                string2 = bufferedReader.readLine();
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
        return string;
    }

    public static String getText(File file) throws IOException {
        return IoUtil.getText(new FileReader(file));
    }

    public static String getText(InputStream inputStream) throws IOException {
        return IoUtil.getText(new InputStreamReader(inputStream));
    }

    public static void createDirectory(File file) throws IOException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Failed to create directory: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        try {
            int n = inputStream.read(byArray);
            while (n > 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(inputStream, outputStream);
            throw throwable;
        }
        IoUtil.closeQuietly(inputStream, outputStream);
    }

    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        if (!file.isFile()) {
            throw new IOException(String.format("Error copying file %s to %s; source file does not exist", file, file2));
        }
        IoUtil.createDirectory(file2.getParentFile());
        IoUtil.doCopyFile(file, file2);
        IoUtil.checkSameSize(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            fileInputStream.getChannel().transferTo(0L, Long.MAX_VALUE, fileOutputStream.getChannel());
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(fileInputStream, fileOutputStream);
            throw throwable;
        }
        IoUtil.closeQuietly(fileInputStream, fileOutputStream);
    }

    private static void checkSameSize(File file, File file2) throws IOException {
        long l;
        long l2 = file.length();
        if (l2 != (l = file2.length())) {
            throw new IOException(String.format("Error copying file %s to %s; source file size is %d, but target file size is %d", file, file2, l2, l));
        }
    }
}

