/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;
import org.spockframework.util.UnreachableCodeError;

public abstract class MopUtil {
    private static final Field ReflectionMetaMethod_method = MopUtil.getDeclaredField(ReflectionMetaMethod.class, "method");
    private static final Field CachedField_field = MopUtil.getDeclaredField(CachedField.class, "field");

    private static Field getDeclaredField(Class clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(String.format("Found an incompatibility between the Spock and Groovy versions you are using: field '%s.%s' does not exist.", clazz, string));
        }
    }

    public static Method methodFor(MetaMethod metaMethod) {
        if (metaMethod instanceof CachedMethod) {
            return ((CachedMethod)metaMethod).getCachedMethod();
        }
        if (metaMethod instanceof ClosureMetaMethod) {
            return ((ClosureMetaMethod)metaMethod).getDoCall().getCachedMethod();
        }
        if (metaMethod instanceof ReflectionMetaMethod) {
            try {
                return ((CachedMethod)ReflectionMetaMethod_method.get(metaMethod)).getCachedMethod();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnreachableCodeError(illegalAccessException);
            }
        }
        return null;
    }

    public static Member memberFor(MetaProperty metaProperty) {
        if (metaProperty instanceof CachedField) {
            try {
                return (Member)CachedField_field.get(metaProperty);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnreachableCodeError(illegalAccessException);
            }
        }
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            if (metaBeanProperty.getGetter() != null) {
                return MopUtil.methodFor(metaBeanProperty.getGetter());
            }
            if (metaBeanProperty.getSetter() != null) {
                return MopUtil.methodFor(metaBeanProperty.getSetter());
            }
            if (metaBeanProperty.getField() != null) {
                return MopUtil.memberFor((MetaProperty)metaBeanProperty.getField());
            }
            return null;
        }
        return null;
    }

    public static Field fieldFor(MetaProperty metaProperty) {
        if (metaProperty instanceof CachedField) {
            try {
                return (Field)CachedField_field.get(metaProperty);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnreachableCodeError(illegalAccessException);
            }
        }
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            if (metaBeanProperty.getField() != null) {
                return MopUtil.fieldFor((MetaProperty)metaBeanProperty.getField());
            }
            return null;
        }
        return null;
    }

    public static Method getterFor(MetaProperty metaProperty) {
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            if (metaBeanProperty.getGetter() != null) {
                return MopUtil.methodFor(metaBeanProperty.getGetter());
            }
            return null;
        }
        return null;
    }

    public static Method setterFor(MetaProperty metaProperty) {
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            if (metaBeanProperty.getSetter() != null) {
                return MopUtil.methodFor(metaBeanProperty.getSetter());
            }
            return null;
        }
        return null;
    }

    public static boolean isReadable(MetaProperty metaProperty) {
        if (metaProperty instanceof CachedField) {
            return true;
        }
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            return metaBeanProperty.getGetter() != null || metaBeanProperty.getField() != null;
        }
        return false;
    }

    public static boolean isWriteable(MetaProperty metaProperty) {
        if (metaProperty instanceof CachedField) {
            return true;
        }
        if (metaProperty instanceof MetaBeanProperty) {
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            return metaBeanProperty.getSetter() != null || metaBeanProperty.getField() != null;
        }
        return false;
    }
}

