/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.IoUtil;
import org.spockframework.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtil {
    public static Class<?> loadClassIfAvailable(String string) {
        try {
            return ReflectionUtil.class.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isClassAvailable(String string) {
        return ReflectionUtil.loadClassIfAvailable(string) != null;
    }

    public static boolean isMethodAvailable(String string, String string2) {
        try {
            Class<?> clazz = ReflectionUtil.class.getClassLoader().loadClass(string);
            return ReflectionUtil.getMethodByName(clazz, string2) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, String string) {
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Method getMethodByName(Class<?> clazz, String string) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodByName(Class<?> clazz, String string) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodBySignature(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getDeclaredMethodBySignature(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static File getClassFile(Class<?> clazz) {
        File file = new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, clazz.getName().replace('.', File.separatorChar) + ".class");
        return file2.isFile() ? file2 : null;
    }

    public static String getSourceCode(String string, String string2) throws IOException {
        String string3 = string.replace('.', '/') + "/" + string2;
        InputStream inputStream = ReflectionUtil.class.getClassLoader().getResourceAsStream(string3);
        return inputStream == null ? null : IoUtil.getText(inputStream);
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        assert (clazz == Void.TYPE);
        return null;
    }

    public static String getPropertyNameForGetterMethod(Method method) {
        if (method.getTypeParameters().length != 0) {
            return null;
        }
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        String string = method.getName();
        if (string.startsWith("get")) {
            return ReflectionUtil.getPropertyName(string, 3);
        }
        if (string.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            return ReflectionUtil.getPropertyName(string, 2);
        }
        return null;
    }

    public static boolean hasAnyOfTypes(Object object, Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static Class[] getTypes(Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = ObjectUtil.getClass(objectArray[i]);
        }
        return classArray;
    }

    private static String getPropertyName(String string, int n) {
        String string2 = string.substring(n);
        if (string2.length() == 0) {
            return null;
        }
        return Introspector.decapitalize(string2);
    }

    public static Object invokeMethod(Object object, Method method, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            ExceptionUtil.sneakyThrow(illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtil.sneakyThrow(invocationTargetException.getCause());
            return null;
        }
    }
}

