/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextUtil {
    public static String repeatChar(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static int getIndent(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n;
    }

    public static int getIndent(List<String> list) {
        int n = Integer.MAX_VALUE;
        for (String string : list) {
            int n2 = TextUtil.getIndent(string);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static String changeIndent(String string, int n) {
        return n > 0 ? TextUtil.repeatChar(' ', n) + string : string.substring(-n);
    }

    public static void changeIndent(List<String> list, int n) {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, TextUtil.changeIndent(list.get(i), n));
        }
    }

    public static String erase(String string, int n, int n2) {
        return string.substring(0, n) + TextUtil.repeatChar(' ', n2 - n) + string.substring(n2);
    }

    public static String erase(String string, int n) {
        return TextUtil.erase(string, n, string.length());
    }

    public static int getTrailingWhitespace(String string) {
        return string.length() - string.trim().length() - TextUtil.getIndent(string);
    }

    public static String join(String string, List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Object ... objectArray) {
        return TextUtil.join(string, Arrays.asList(objectArray));
    }

    public static int countOccurrences(String string, char c) {
        int n = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static String escape(char c) {
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\f') {
            return "\\f";
        }
        return String.valueOf(c);
    }

    public static String escape(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 3 / 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            stringBuilder.append(TextUtil.escape(charSequence.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static String printStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static long longHashCode(String string) {
        long l = 1125899906842597L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            l = 31L * l + (long)string.charAt(i);
        }
        return l;
    }
}

