/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber UNKNOWN = new VersionNumber(0, 0, 0, null);
    private static final Pattern versionPattern = Pattern.compile("(\\d+)(?:\\.(\\d+))?+(?:\\.(\\d+))?+(?:[-\\.](.+))?");
    private static final String versionTemplate = "%d.%d.%d%s";
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public VersionNumber(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        if (this.major != versionNumber.major) {
            return this.major - versionNumber.major;
        }
        if (this.minor != versionNumber.minor) {
            return this.minor - versionNumber.minor;
        }
        if (this.micro != versionNumber.micro) {
            return this.micro - versionNumber.micro;
        }
        return ObjectUtil.compare(this.qualifier, versionNumber.qualifier);
    }

    public boolean equals(Object object) {
        return object instanceof VersionNumber && this.compareTo((VersionNumber)object) == 0;
    }

    public int hashCode() {
        int n = this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.micro;
        n = 31 * n + ObjectUtil.hashCode(this.qualifier);
        return n;
    }

    public String toString() {
        return String.format(versionTemplate, this.major, this.minor, this.micro, this.qualifier == null ? "" : "-" + this.qualifier);
    }

    public static VersionNumber parse(String string) {
        if (string == null) {
            return UNKNOWN;
        }
        Matcher matcher = versionPattern.matcher(string);
        if (!matcher.matches()) {
            return UNKNOWN;
        }
        int n = Integer.valueOf(matcher.group(1));
        String string2 = matcher.group(2);
        int n2 = string2 == null ? 0 : Integer.valueOf(string2);
        String string3 = matcher.group(3);
        int n3 = string3 == null ? 0 : Integer.valueOf(string3);
        String string4 = matcher.group(4);
        return new VersionNumber(n, n2, n3, string4);
    }
}

