/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util.inspector;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.util.inspector.AstInspectorException;
import org.spockframework.util.inspector.Inspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstInspector {
    private static final String EXPRESSION_MARKER_PREFIX = "inspect_";
    private CompilePhase compilePhase = CompilePhase.CONVERSION;
    private boolean throwOnNodeNotFound = true;
    private final MyClassLoader classLoader;
    private final MyVisitor visitor = new MyVisitor();
    private ModuleNode module;
    private final Map<String, AnnotatedNode> markedNodes = new HashMap<String, AnnotatedNode>();
    private final Map<String, ClassNode> classes = new HashMap<String, ClassNode>();
    private final Map<String, FieldNode> fields = new HashMap<String, FieldNode>();
    private final Map<String, PropertyNode> properties = new HashMap<String, PropertyNode>();
    private final Map<String, ConstructorNode> constructors = new HashMap<String, ConstructorNode>();
    private final Map<String, MethodNode> methods = new HashMap<String, MethodNode>();
    private final Map<String, Statement> statements = new HashMap<String, Statement>();
    private final Map<String, Expression> expressions = new HashMap<String, Expression>();

    public AstInspector() {
        this.classLoader = new MyClassLoader(AstInspector.class.getClassLoader(), null);
    }

    public AstInspector(CompilePhase compilePhase) {
        this();
        this.setCompilePhase(compilePhase);
    }

    public AstInspector(ClassLoader classLoader, CompilerConfiguration compilerConfiguration) {
        this.classLoader = new MyClassLoader(classLoader, compilerConfiguration);
    }

    public void setCompilePhase(CompilePhase compilePhase) {
        if (compilePhase.getPhaseNumber() < CompilePhase.CONVERSION.getPhaseNumber()) {
            throw new IllegalArgumentException("AST is only available from phase CONVERSION onwards");
        }
        this.compilePhase = compilePhase;
    }

    public void setThrowOnNodeNotFound(boolean bl) {
        this.throwOnNodeNotFound = bl;
    }

    public void load(String string) throws CompilationFailedException {
        this.reset();
        try {
            this.classLoader.parseClass(string);
        }
        catch (AstSuccessfullyCaptured astSuccessfullyCaptured) {
            this.indexAstNodes();
            return;
        }
        throw new AstInspectorException("internal error");
    }

    public void load(File file) throws CompilationFailedException {
        this.reset();
        try {
            this.classLoader.parseClass(file);
        }
        catch (IOException iOException) {
            throw new AstInspectorException("cannot read source file", iOException);
        }
        catch (AstSuccessfullyCaptured astSuccessfullyCaptured) {
            this.indexAstNodes();
            return;
        }
        throw new AstInspectorException("internal error");
    }

    public void load(InputStream inputStream) throws CompilationFailedException {
        this.reset();
        try {
            this.classLoader.parseClass(inputStream);
        }
        catch (AstSuccessfullyCaptured astSuccessfullyCaptured) {
            this.indexAstNodes();
            return;
        }
        throw new AstInspectorException("internal error");
    }

    public ModuleNode getModule() {
        return this.module;
    }

    public AnnotatedNode getMarkedNode(String string) {
        return this.getNode(this.markedNodes, string);
    }

    public ClassNode getClass(String string) {
        return this.getNode(this.classes, string);
    }

    public FieldNode getField(String string) {
        return this.getNode(this.fields, string);
    }

    public PropertyNode getProperty(String string) {
        return this.getNode(this.properties, string);
    }

    public ConstructorNode getConstructor(String string) {
        return this.getNode(this.constructors, string);
    }

    public MethodNode getMethod(String string) {
        return this.getNode(this.methods, string);
    }

    public List<Statement> getScriptStatements() {
        return AstInspector.getStatements(this.module.getStatementBlock());
    }

    public List<Expression> getScriptExpressions() {
        return AstInspector.getExpressions(this.getScriptStatements());
    }

    public List<Statement> getStatements(MethodNode methodNode) {
        return AstInspector.getStatements((BlockStatement)methodNode.getCode());
    }

    public List<Expression> getExpressions(MethodNode methodNode) {
        return AstInspector.getExpressions(this.getStatements(methodNode));
    }

    public List<Statement> getStatements(ClosureExpression closureExpression) {
        return AstInspector.getStatements((BlockStatement)closureExpression.getCode());
    }

    public List<Expression> getExpressions(ClosureExpression closureExpression) {
        return AstInspector.getExpressions(this.getStatements(closureExpression));
    }

    public Statement getStatement(String string) {
        return this.getNode(this.statements, string);
    }

    public Expression getExpression(String string) {
        return this.getNode(this.expressions, string);
    }

    private void indexAstNodes() {
        this.visitor.visitBlockStatement(this.module.getStatementBlock());
        for (MethodNode methodNode : this.module.getMethods()) {
            this.visitor.visitMethod(methodNode);
        }
        for (MethodNode methodNode : this.module.getClasses()) {
            this.visitor.visitClass((ClassNode)methodNode);
        }
    }

    private void reset() {
        this.module = null;
        this.markedNodes.clear();
        this.classes.clear();
        this.fields.clear();
        this.properties.clear();
        this.constructors.clear();
        this.methods.clear();
        this.statements.clear();
        this.expressions.clear();
    }

    private <T extends ASTNode> void addNode(Map<String, T> map, String string, T t) {
        if (!map.containsKey(string)) {
            map.put(string, t);
        }
    }

    private <T> T getNode(Map<String, T> map, String string) {
        T t = map.get(string);
        if (t == null && this.throwOnNodeNotFound) {
            throw new AstInspectorException(String.format("cannot find a node named '%s' of the requested kind", string));
        }
        return t;
    }

    private static List<Statement> getStatements(BlockStatement blockStatement) {
        return blockStatement == null ? Collections.emptyList() : blockStatement.getStatements();
    }

    private static List<Expression> getExpressions(List<Statement> list) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Statement statement : list) {
            if (!(statement instanceof ExpressionStatement)) continue;
            arrayList.add(((ExpressionStatement)statement).getExpression());
        }
        return arrayList;
    }

    private static class AstSuccessfullyCaptured
    extends Error {
        private AstSuccessfullyCaptured() {
        }
    }

    private class MyVisitor
    extends ClassCodeVisitorSupport {
        private MyVisitor() {
        }

        public void visitAnnotations(AnnotatedNode annotatedNode) {
            for (AnnotationNode annotationNode : annotatedNode.getAnnotations()) {
                ClassNode classNode = annotationNode.getClassNode();
                if (!classNode.getNameWithoutPackage().equals(Inspect.class.getSimpleName())) continue;
                ConstantExpression constantExpression = (ConstantExpression)annotationNode.getMember("value");
                if (constantExpression == null || !(constantExpression.getValue() instanceof String)) {
                    throw new AstInspectorException("@Inspect must have a String argument");
                }
                AstInspector.this.addNode(AstInspector.this.markedNodes, (String)constantExpression.getValue(), (ASTNode)annotatedNode);
                break;
            }
            super.visitAnnotations(annotatedNode);
        }

        public void visitClass(ClassNode classNode) {
            AstInspector.this.addNode(AstInspector.this.classes, classNode.getNameWithoutPackage(), (ASTNode)classNode);
            super.visitClass(classNode);
        }

        public void visitField(FieldNode fieldNode) {
            AstInspector.this.addNode(AstInspector.this.fields, fieldNode.getName(), (ASTNode)fieldNode);
            super.visitField(fieldNode);
        }

        public void visitProperty(PropertyNode propertyNode) {
            AstInspector.this.addNode(AstInspector.this.properties, propertyNode.getName(), (ASTNode)propertyNode);
            super.visitProperty(propertyNode);
        }

        protected void visitConstructorOrMethod(MethodNode methodNode, boolean bl) {
            for (Parameter parameter : methodNode.getParameters()) {
                this.visitAnnotations((AnnotatedNode)parameter);
                if (parameter.getInitialExpression() == null) continue;
                parameter.getInitialExpression().visit((GroovyCodeVisitor)this);
            }
            super.visitConstructorOrMethod(methodNode, bl);
        }

        public void visitConstructor(ConstructorNode constructorNode) {
            AstInspector.this.addNode(AstInspector.this.constructors, constructorNode.getDeclaringClass().getNameWithoutPackage(), (ASTNode)constructorNode);
            super.visitConstructor(constructorNode);
        }

        public void visitMethod(MethodNode methodNode) {
            AstInspector.this.addNode(AstInspector.this.methods, methodNode.getName(), (ASTNode)methodNode);
            super.visitMethod(methodNode);
        }

        public void visitStatement(Statement statement) {
            if (statement.getStatementLabel() != null) {
                AstInspector.this.addNode(AstInspector.this.statements, statement.getStatementLabel(), (ASTNode)statement);
                if (statement instanceof ExpressionStatement) {
                    AstInspector.this.addNode(AstInspector.this.expressions, statement.getStatementLabel(), (ASTNode)((ExpressionStatement)statement).getExpression());
                }
            }
            super.visitStatement(statement);
        }

        public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
            ArgumentListExpression argumentListExpression;
            String string;
            if (methodCallExpression.isImplicitThis() && (string = methodCallExpression.getMethodAsString()) != null && string.startsWith(AstInspector.EXPRESSION_MARKER_PREFIX) && (argumentListExpression = (ArgumentListExpression)methodCallExpression.getArguments()) != null && argumentListExpression.getExpressions().size() == 1) {
                AstInspector.this.addNode(AstInspector.this.expressions, string.substring(AstInspector.EXPRESSION_MARKER_PREFIX.length()), (ASTNode)argumentListExpression.getExpressions().get(0));
            }
            super.visitMethodCallExpression(methodCallExpression);
        }

        protected SourceUnit getSourceUnit() {
            throw new AstInspectorException("internal error");
        }
    }

    private class MyClassLoader
    extends GroovyClassLoader {
        MyClassLoader(ClassLoader classLoader, CompilerConfiguration compilerConfiguration) {
            super(classLoader, compilerConfiguration);
        }

        protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
            CompilationUnit compilationUnit = super.createCompilationUnit(compilerConfiguration, codeSource);
            compilationUnit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                public void call(SourceUnit sourceUnit) throws CompilationFailedException {
                    AstInspector.this.module = sourceUnit.getAST();
                    throw new AstSuccessfullyCaptured();
                }
            }, AstInspector.this.compilePhase.getPhaseNumber());
            return compilationUnit;
        }
    }
}

