/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;

public class AsyncConditions {
    private final int numEvalBlocks;
    private final CountDownLatch latch;
    private final ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue();

    public AsyncConditions() {
        this(1);
    }

    public AsyncConditions(int n) {
        this.numEvalBlocks = n;
        this.latch = new CountDownLatch(n);
    }

    public void evaluate(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            this.exceptions.add(throwable);
            this.wakeUp();
        }
        this.latch.countDown();
    }

    private void wakeUp() {
        long l = this.latch.getCount();
        int n = 0;
        while ((long)n < l) {
            this.latch.countDown();
            ++n;
        }
    }

    public void await() throws InterruptedException, Throwable {
        this.await(1, TimeUnit.SECONDS);
    }

    public void await(int n, TimeUnit timeUnit) throws InterruptedException, Throwable {
        this.latch.await(n, timeUnit);
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.poll();
        }
        long l = this.latch.getCount();
        if (l > 0L) {
            throw new SpockTimeoutError(n, timeUnit, "Async conditions timed out after %d %s; %d out of %d evaluate blocks did not complete in time", n, timeUnit.toString().toLowerCase(), l, this.numEvalBlocks);
        }
    }
}

