/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingVariable<T> {
    private final int timeout;
    private final TimeUnit unit;
    private T value;
    private final CountDownLatch valueReady = new CountDownLatch(1);

    public BlockingVariable() {
        this(1, TimeUnit.SECONDS);
    }

    public BlockingVariable(int n) {
        this(n, TimeUnit.SECONDS);
    }

    public BlockingVariable(int n, TimeUnit timeUnit) {
        this.timeout = n;
        this.unit = timeUnit;
    }

    public T get() throws InterruptedException {
        if (!this.valueReady.await(this.timeout, this.unit)) {
            throw new SpockTimeoutError(this.timeout, this.unit, "BlockingVariable.get() timed out after %d %s", this.timeout, this.unit.toString().toLowerCase());
        }
        return this.value;
    }

    public void set(T t) {
        this.value = t;
        this.valueReady.countDown();
    }
}

