/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.aggregator;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.aggregator.AggregatorFunctionProperties;
import org.springframework.cloud.fn.aggregator.MessageStoreConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingCorrelationStrategy;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingReleaseStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.integration.config.AggregatorFactoryBean;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AggregatorFunctionProperties.class})
public class AggregatorFunctionConfiguration {
    @Autowired
    private AggregatorFunctionProperties properties;
    @Autowired
    private BeanFactory beanFactory;

    @Bean
    public Function<Flux<Message<?>>, Flux<Message<?>>> aggregatorFunction(FluxMessageChannel inputChannel, FluxMessageChannel outputChannel) {
        return input -> Flux.from((Publisher)outputChannel).doOnSubscribe(sub -> inputChannel.subscribeTo((Publisher)input));
    }

    @Bean
    public FluxMessageChannel inputChannel() {
        return new FluxMessageChannel();
    }

    @Bean
    public FluxMessageChannel outputChannel() {
        return new FluxMessageChannel();
    }

    @Bean
    @ServiceActivator(inputChannel="inputChannel")
    public AggregatorFactoryBean aggregator(ObjectProvider<CorrelationStrategy> correlationStrategy, ObjectProvider<ReleaseStrategy> releaseStrategy, ObjectProvider<MessageGroupProcessor> messageGroupProcessor, ObjectProvider<MessageGroupStore> messageStore, @Qualifier(value="outputChannel") MessageChannel outputChannel) {
        AggregatorFactoryBean aggregator = new AggregatorFactoryBean();
        aggregator.setExpireGroupsUponCompletion(Boolean.valueOf(true));
        aggregator.setSendPartialResultOnExpiry(Boolean.valueOf(true));
        aggregator.setGroupTimeoutExpression(this.properties.getGroupTimeout());
        aggregator.setCorrelationStrategy((CorrelationStrategy)correlationStrategy.getIfAvailable());
        aggregator.setReleaseStrategy((ReleaseStrategy)releaseStrategy.getIfAvailable());
        MessageGroupProcessor groupProcessor = (MessageGroupProcessor)messageGroupProcessor.getIfAvailable();
        if (groupProcessor == null) {
            groupProcessor = new DefaultAggregatingMessageGroupProcessor();
            ((BeanFactoryAware)groupProcessor).setBeanFactory(this.beanFactory);
        }
        aggregator.setProcessorBean((Object)groupProcessor);
        aggregator.setMessageStore((MessageGroupStore)messageStore.getIfAvailable());
        aggregator.setOutputChannel(outputChannel);
        return aggregator;
    }

    @Bean
    @ConditionalOnProperty(prefix="aggregator", name={"correlation"})
    @ConditionalOnMissingBean
    public CorrelationStrategy correlationStrategy() {
        return new ExpressionEvaluatingCorrelationStrategy(this.properties.getCorrelation());
    }

    @Bean
    @ConditionalOnProperty(prefix="aggregator", name={"release"})
    @ConditionalOnMissingBean
    public ReleaseStrategy releaseStrategy() {
        return new ExpressionEvaluatingReleaseStrategy(this.properties.getRelease());
    }

    @Bean
    @ConditionalOnProperty(prefix="aggregator", name={"aggregation"})
    @ConditionalOnMissingBean
    public MessageGroupProcessor messageGroupProcessor() {
        return new ExpressionEvaluatingMessageGroupProcessor(this.properties.getAggregation().getExpressionString());
    }

    @Configuration
    @ConditionalOnMissingBean(value={MessageGroupStore.class})
    @Import(value={MessageStoreConfiguration.Mongo.class, MessageStoreConfiguration.Redis.class, MessageStoreConfiguration.Gemfire.class, MessageStoreConfiguration.Jdbc.class})
    protected static class MessageStoreAutoConfiguration {
        protected MessageStoreAutoConfiguration() {
        }
    }
}

