/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.aggregator;

import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;

public class ExcludeStoresAutoConfigurationEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Properties properties = new Properties();
        properties.setProperty("spring.autoconfigure.exclude", DataSourceAutoConfiguration.class.getName() + ", " + DataSourceTransactionManagerAutoConfiguration.class.getName() + ", " + MongoAutoConfiguration.class.getName() + ", " + MongoDataAutoConfiguration.class.getName() + ", " + MongoRepositoriesAutoConfiguration.class.getName() + ", " + EmbeddedMongoAutoConfiguration.class.getName() + ", " + ClientCacheAutoConfiguration.class.getName() + ", " + RedisAutoConfiguration.class.getName() + ", " + RedisRepositoriesAutoConfiguration.class.getName());
        propertySources.addLast((PropertySource)new PropertiesPropertySource("aggregator.exclude.stores.auto-configuration", properties));
    }
}

