/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.aggregator;

import java.util.Arrays;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration;
import org.springframework.cloud.fn.aggregator.AggregatorFunctionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.integration.gemfire.store.GemfireMessageStore;
import org.springframework.integration.jdbc.store.JdbcMessageStore;
import org.springframework.integration.mongodb.store.ConfigurableMongoDbMessageStore;
import org.springframework.integration.mongodb.support.BinaryToMessageConverter;
import org.springframework.integration.mongodb.support.MessageToBinaryConverter;
import org.springframework.integration.redis.store.RedisMessageStore;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

class MessageStoreConfiguration {
    MessageStoreConfiguration() {
    }

    @ConditionalOnClass(value={JdbcMessageStore.class})
    @ConditionalOnProperty(prefix="aggregator", name={"message-store-type"}, havingValue="jdbc")
    @Import(value={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
    static class Jdbc {
        Jdbc() {
        }

        @Bean
        public MessageGroupStore messageStore(JdbcTemplate jdbcTemplate, AggregatorFunctionProperties properties) {
            JdbcMessageStore messageStore = new JdbcMessageStore((JdbcOperations)jdbcTemplate);
            if (StringUtils.hasText((String)properties.getMessageStoreEntity())) {
                messageStore.setTablePrefix(properties.getMessageStoreEntity());
            }
            return messageStore;
        }
    }

    @ConditionalOnClass(value={GemfireMessageStore.class})
    @ConditionalOnProperty(prefix="aggregator", name={"message-store-type"}, havingValue="gemfire")
    @Import(value={ClientCacheAutoConfiguration.class})
    @EnablePdx
    static class Gemfire {
        Gemfire() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ClientRegionFactoryBean<?, ?> gemfireRegion(GemFireCache cache, AggregatorFunctionProperties properties) {
            ClientRegionFactoryBean clientRegionFactoryBean = new ClientRegionFactoryBean();
            clientRegionFactoryBean.setCache(cache);
            clientRegionFactoryBean.setName(properties.getMessageStoreEntity());
            return clientRegionFactoryBean;
        }

        @Bean
        public MessageGroupStore messageStore(Region<Object, Object> region) {
            return new GemfireMessageStore(region);
        }
    }

    @ConditionalOnClass(value={RedisMessageStore.class})
    @ConditionalOnProperty(prefix="aggregator", name={"message-store-type"}, havingValue="redis")
    @Import(value={RedisAutoConfiguration.class})
    static class Redis {
        Redis() {
        }

        @Bean
        public MessageGroupStore messageStore(RedisTemplate<?, ?> redisTemplate) {
            return new RedisMessageStore(redisTemplate.getConnectionFactory());
        }
    }

    @ConditionalOnClass(value={ConfigurableMongoDbMessageStore.class})
    @ConditionalOnProperty(prefix="aggregator", name={"message-store-type"}, havingValue="mongodb")
    @Import(value={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, EmbeddedMongoAutoConfiguration.class})
    static class Mongo {
        Mongo() {
        }

        @Bean
        public MessageGroupStore messageStore(MongoTemplate mongoTemplate, AggregatorFunctionProperties properties) {
            if (StringUtils.hasText((String)properties.getMessageStoreEntity())) {
                return new ConfigurableMongoDbMessageStore(mongoTemplate, properties.getMessageStoreEntity());
            }
            return new ConfigurableMongoDbMessageStore(mongoTemplate);
        }

        @Bean
        @Primary
        public MongoCustomConversions mongoDbCustomConversions() {
            return new MongoCustomConversions(Arrays.asList(new MessageToBinaryConverter(), new BinaryToMessageConverter()));
        }
    }
}

