/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.http.request;

import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.http.request.HttpRequestFunctionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.messaging.Message;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HttpRequestFunctionProperties.class})
public class HttpRequestFunctionConfiguration {
    @Bean
    public HttpRequestFunction httpRequestFunction(WebClient.Builder webClientBuilder, HttpRequestFunctionProperties properties) {
        return new HttpRequestFunction(webClientBuilder.build(), properties);
    }

    @Bean
    @IntegrationConverter
    public Converter<String, HttpMethod> httpMethodConverter() {
        return new HttpMethodConverter();
    }

    public static class HttpRequestFunction
    implements Function<Message<?>, Object> {
        private final WebClient webClient;
        private final UriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
        private final HttpRequestFunctionProperties properties;

        public HttpRequestFunction(WebClient webClient, HttpRequestFunctionProperties properties) {
            this.webClient = webClient;
            this.properties = properties;
        }

        @Override
        public Object apply(Message<?> message) {
            return ((WebClient.RequestBodySpec)this.webClient.method(this.resolveHttpMethod(message)).uri(this.uriBuilderFactory.uriString(this.resolveUrl(message)).build(new Object[0]))).bodyValue(this.resolveBody(message)).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)this.resolveHeaders(message))).retrieve().toEntity(this.properties.getExpectedResponseType()).map(responseEntity -> this.properties.getReplyExpression().getValue(responseEntity)).timeout(Duration.ofMillis(this.properties.getTimeout())).block();
        }

        private String resolveUrl(Message<?> message) {
            return (String)this.properties.getUrlExpression().getValue(message, String.class);
        }

        private HttpMethod resolveHttpMethod(Message<?> message) {
            return (HttpMethod)this.properties.getHttpMethodExpression().getValue(message, HttpMethod.class);
        }

        private Object resolveBody(Message<?> message) {
            return this.properties.getBodyExpression() != null ? this.properties.getBodyExpression().getValue(message) : message.getPayload();
        }

        private HttpHeaders resolveHeaders(Message<?> message) {
            HttpHeaders headers = new HttpHeaders();
            if (this.properties.getHeadersExpression() != null) {
                Map headersMap = (Map)this.properties.getHeadersExpression().getValue(message, Map.class);
                for (Map.Entry header : headersMap.entrySet()) {
                    if (header.getKey() == null || header.getValue() == null) continue;
                    headers.add(header.getKey().toString(), header.getValue().toString());
                }
            }
            return headers;
        }
    }

    public static class HttpMethodConverter
    implements Converter<String, HttpMethod> {
        public HttpMethod convert(String source) {
            return HttpMethod.valueOf((String)source);
        }
    }
}

