/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.http.request;

import jakarta.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="http.request")
public class HttpRequestFunctionProperties {
    private static final Class<?> DEFAULT_RESPONSE_TYPE = String.class;
    private Class<?> expectedResponseType = DEFAULT_RESPONSE_TYPE;
    private long timeout = 30000L;
    private Expression urlExpression;
    private Expression httpMethodExpression = new ValueExpression((Object)HttpMethod.GET);
    private Expression bodyExpression;
    private Expression headersExpression;
    private Expression replyExpression = new FunctionExpression(HttpEntity::getBody);

    @NotNull
    public Expression getUrlExpression() {
        return this.urlExpression;
    }

    public void setUrlExpression(Expression urlExpression) {
        this.urlExpression = urlExpression;
    }

    public Expression getHttpMethodExpression() {
        return this.httpMethodExpression;
    }

    public void setHttpMethodExpression(Expression httpMethodExpression) {
        this.httpMethodExpression = httpMethodExpression;
    }

    @NotNull
    public Class<?> getExpectedResponseType() {
        return this.expectedResponseType;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        this.expectedResponseType = expectedResponseType;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Expression getBodyExpression() {
        return this.bodyExpression;
    }

    public void setBodyExpression(Expression bodyExpression) {
        this.bodyExpression = bodyExpression;
    }

    public Expression getHeadersExpression() {
        return this.headersExpression;
    }

    public void setHeadersExpression(Expression headersExpression) {
        this.headersExpression = headersExpression;
    }

    @NotNull
    public Expression getReplyExpression() {
        return this.replyExpression;
    }

    public void setReplyExpression(Expression replyExpression) {
        this.replyExpression = replyExpression;
    }
}

