/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.test.support.file.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class RemoteFileTestSupport {
    protected static final int port = 0;
    @TempDir
    protected static Path remoteTemporaryFolder;
    @TempDir
    protected static Path localTemporaryFolder;
    protected volatile File sourceRemoteDirectory;
    protected volatile File targetRemoteDirectory;
    protected volatile File sourceLocalDirectory;
    protected volatile File targetLocalDirectory;

    public File getSourceRemoteDirectory() {
        return this.sourceRemoteDirectory;
    }

    public File getTargetRemoteDirectory() {
        return this.targetRemoteDirectory;
    }

    public File getSourceLocalDirectory() {
        return this.sourceLocalDirectory;
    }

    public File getTargetLocalDirectory() {
        return this.targetLocalDirectory;
    }

    @BeforeEach
    public void setupFolders() throws IOException {
        String prefix = this.prefix();
        RemoteFileTestSupport.recursiveDelete(new File(remoteTemporaryFolder.toFile(), prefix + "Source"));
        this.sourceRemoteDirectory = new File(remoteTemporaryFolder.toFile(), prefix + "Source");
        this.sourceRemoteDirectory.mkdirs();
        RemoteFileTestSupport.recursiveDelete(new File(remoteTemporaryFolder.toFile(), prefix + "Target"));
        this.targetRemoteDirectory = new File(remoteTemporaryFolder.toFile(), prefix + "Target");
        this.targetRemoteDirectory.mkdirs();
        RemoteFileTestSupport.recursiveDelete(new File(localTemporaryFolder.toFile(), "localSource"));
        this.sourceLocalDirectory = new File(localTemporaryFolder.toFile(), "localSource");
        this.sourceLocalDirectory.mkdirs();
        RemoteFileTestSupport.recursiveDelete(new File(localTemporaryFolder.toFile(), "localTarget"));
        this.targetLocalDirectory = new File(localTemporaryFolder.toFile(), "localTarget");
        this.targetLocalDirectory.mkdirs();
        File file = new File(this.sourceRemoteDirectory, prefix + "Source1.txt");
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(file);
        fos.write("source1".getBytes());
        fos.close();
        file = new File(this.sourceRemoteDirectory, prefix + "Source2.txt");
        file.createNewFile();
        fos = new FileOutputStream(file);
        fos.write("source2".getBytes());
        fos.close();
        file = new File(this.sourceLocalDirectory, "localSource1.txt");
        file.createNewFile();
        fos = new FileOutputStream(file);
        fos.write("local1".getBytes());
        fos.close();
        file = new File(this.sourceLocalDirectory, "localSource2.txt");
        file.createNewFile();
        fos = new FileOutputStream(file);
        fos.write("local2".getBytes());
        fos.close();
    }

    public static void recursiveDelete(File file) {
        if (file != null && file.exists()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File fyle : files) {
                    if (fyle.isDirectory()) {
                        RemoteFileTestSupport.recursiveDelete(fyle);
                        continue;
                    }
                    fyle.delete();
                }
            }
            file.delete();
        }
    }

    protected String prefix() {
        return "remote";
    }
}

