/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.test.support.ftp;

import java.io.File;
import java.util.Arrays;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.springframework.cloud.fn.test.support.file.remote.RemoteFileTestSupport;

public class FtpTestSupport
extends RemoteFileTestSupport {
    private static final FtpServerFactory serverFactory = new FtpServerFactory();
    private static volatile FtpServer server;

    public String getTargetLocalDirectoryName() {
        return this.targetLocalDirectory.getAbsolutePath() + File.separator;
    }

    @BeforeAll
    public static void createServer() throws Exception {
        serverFactory.setUserManager((UserManager)new TestUserManager(remoteTemporaryFolder.toFile().getAbsolutePath()));
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(0);
        serverFactory.addListener("default", factory.createListener());
        server = serverFactory.createServer();
        server.start();
        System.setProperty("ftp.factory.port", String.valueOf(serverFactory.getListener("default").getPort()));
        System.setProperty("ftp.localDir", localTemporaryFolder.toFile().getAbsolutePath() + File.separator + "localTarget");
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
        System.clearProperty("ftp.factory.port");
        System.clearProperty("ftp.localDir");
    }

    @Override
    protected String prefix() {
        return "ftp";
    }

    private static final class TestUserManager
    implements UserManager {
        private final BaseUser testUser = new BaseUser();

        private TestUserManager(String homeDirectory) {
            this.testUser.setAuthorities(Arrays.asList(new ConcurrentLoginPermission(1024, 1024), new WritePermission(), new TransferRatePermission(1024, 1024)));
            this.testUser.setHomeDirectory(homeDirectory);
            this.testUser.setName("TEST_USER");
        }

        public User getUserByName(String s) {
            return this.testUser;
        }

        public String[] getAllUserNames() {
            return new String[]{"TEST_USER"};
        }

        public void delete(String s) {
        }

        public void save(User user) {
        }

        public boolean doesExist(String s) {
            return true;
        }

        public User authenticate(Authentication authentication) {
            return this.testUser;
        }

        public String getAdminName() {
            return "admin";
        }

        public boolean isAdmin(String s) {
            return s.equals("admin");
        }
    }
}

