/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.test.support.sftp;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.springframework.cloud.fn.test.support.file.remote.RemoteFileTestSupport;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class SftpTestSupport
extends RemoteFileTestSupport {
    private static SshServer server;

    @Override
    public String prefix() {
        return "sftp";
    }

    @BeforeAll
    public static void createServer() throws Exception {
        server = SshServer.setUpDefaultServer();
        server.setPasswordAuthenticator((username, password, session) -> StringUtils.hasText((String)password) && !"badPassword".equals(password));
        server.setPublickeyAuthenticator((username, key, session) -> key.equals(SftpTestSupport.decodePublicKey("id_rsa_pp.pub")));
        server.setPort(0);
        server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("hostkey.ser").toPath()));
        server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        server.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(remoteTemporaryFolder));
        server.start();
        System.setProperty("sftp.factory.port", String.valueOf(server.getPort()));
        System.setProperty("sftp.consumer.localDir", localTemporaryFolder + File.separator + "localTarget");
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
        File hostkey = new File("hostkey.ser");
        if (hostkey.exists()) {
            hostkey.delete();
        }
        System.clearProperty("sftp.factory.port");
        System.clearProperty("sftp.consumer.localDir");
    }

    private static PublicKey decodePublicKey(String key) {
        try {
            InputStream stream = new ClassPathResource(key).getInputStream();
            byte[] keyBytes = FileCopyUtils.copyToByteArray((InputStream)stream);
            while (keyBytes[keyBytes.length - 1] == 10 || keyBytes[keyBytes.length - 1] == 13) {
                keyBytes = Arrays.copyOf(keyBytes, keyBytes.length - 1);
            }
            byte[] decodeBuffer = Base64.getDecoder().decode(keyBytes);
            ByteBuffer bb = ByteBuffer.wrap(decodeBuffer);
            int len = bb.getInt();
            byte[] type = new byte[len];
            bb.get(type);
            if ("ssh-rsa".equals(new String(type))) {
                BigInteger e = SftpTestSupport.decodeBigInt(bb);
                BigInteger m = SftpTestSupport.decodeBigInt(bb);
                RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
                return KeyFactory.getInstance("RSA").generatePublic(spec);
            }
            throw new IllegalArgumentException("Only supports RSA");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to determine the test public key", ex);
        }
    }

    private static BigInteger decodeBigInt(ByteBuffer bb) {
        int len = bb.getInt();
        byte[] bytes = new byte[len];
        bb.get(bytes);
        return new BigInteger(bytes);
    }
}

